/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.csv;

import com.google.common.collect.ImmutableSet;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.DecoderTestColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.csv.CsvRowDecoderFactory;
import io.prestosql.decoder.util.DecoderTestUtil;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCsvDecoder {
    private static final CsvRowDecoderFactory DECODER_FACTORY = new CsvRowDecoderFactory();

    @Test
    public void testSimple() {
        String csv = "\"row 1\",row2,\"row3\",100,\"200\",300,4.5";
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createVarcharType((int)2), "0", null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)VarcharType.createVarcharType((int)10), "1", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)VarcharType.createVarcharType((int)10), "2", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BigintType.BIGINT, "3", null, null, false, false, false);
        DecoderTestColumnHandle row5 = new DecoderTestColumnHandle(4, "row5", (Type)BigintType.BIGINT, "4", null, null, false, false, false);
        DecoderTestColumnHandle row6 = new DecoderTestColumnHandle(5, "row6", (Type)BigintType.BIGINT, "5", null, null, false, false, false);
        DecoderTestColumnHandle row7 = new DecoderTestColumnHandle(6, "row7", (Type)DoubleType.DOUBLE, "6", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2, (Object)row3, (Object)row4, (Object)row5, (Object)row6, (Object[])new DecoderColumnHandle[]{row7});
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)columns);
        Map decodedRow = (Map)rowDecoder.decodeRow(csv.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        Assert.assertEquals((int)decodedRow.size(), (int)columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row1, "ro");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row2, "row2");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row3, "row3");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row4, 100L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row5, 200L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row6, 300L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row7, 4.5);
    }

    @Test
    public void testBoolean() {
        String csv = "True,False,0,1,\"0\",\"1\",\"true\",\"false\"";
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)BooleanType.BOOLEAN, "0", null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)BooleanType.BOOLEAN, "1", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)BooleanType.BOOLEAN, "2", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BooleanType.BOOLEAN, "3", null, null, false, false, false);
        DecoderTestColumnHandle row5 = new DecoderTestColumnHandle(4, "row5", (Type)BooleanType.BOOLEAN, "4", null, null, false, false, false);
        DecoderTestColumnHandle row6 = new DecoderTestColumnHandle(5, "row6", (Type)BooleanType.BOOLEAN, "5", null, null, false, false, false);
        DecoderTestColumnHandle row7 = new DecoderTestColumnHandle(6, "row7", (Type)BooleanType.BOOLEAN, "6", null, null, false, false, false);
        DecoderTestColumnHandle row8 = new DecoderTestColumnHandle(7, "row8", (Type)BooleanType.BOOLEAN, "7", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2, (Object)row3, (Object)row4, (Object)row5, (Object)row6, (Object[])new DecoderColumnHandle[]{row7, row8});
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)columns);
        Map decodedRow = (Map)rowDecoder.decodeRow(csv.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        Assert.assertEquals((int)decodedRow.size(), (int)columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row1, true);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row2, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row3, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row4, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row5, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row6, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row7, true);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row8, false);
    }

    @Test
    public void testNulls() {
        String csv = ",,,";
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createVarcharType((int)10), "0", null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)BigintType.BIGINT, "1", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)DoubleType.DOUBLE, "2", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BooleanType.BOOLEAN, "3", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2, (Object)row3, (Object)row4);
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)columns);
        Map decodedRow = (Map)rowDecoder.decodeRow(csv.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        Assert.assertEquals((int)decodedRow.size(), (int)columns.size());
        DecoderTestUtil.checkIsNull(decodedRow, row1);
        DecoderTestUtil.checkIsNull(decodedRow, row2);
        DecoderTestUtil.checkIsNull(decodedRow, row3);
        DecoderTestUtil.checkIsNull(decodedRow, row4);
    }

    @Test
    public void testLessTokensThanColumns() {
        String csv = "ala,10";
        DecoderTestColumnHandle column1 = new DecoderTestColumnHandle(0, "column1", (Type)VarcharType.createVarcharType((int)10), "0", null, null, false, false, false);
        DecoderTestColumnHandle column2 = new DecoderTestColumnHandle(1, "column2", (Type)BigintType.BIGINT, "1", null, null, false, false, false);
        DecoderTestColumnHandle column3 = new DecoderTestColumnHandle(2, "column3", (Type)VarcharType.createVarcharType((int)10), "2", null, null, false, false, false);
        DecoderTestColumnHandle column4 = new DecoderTestColumnHandle(0, "column4", (Type)BigintType.BIGINT, "3", null, null, false, false, false);
        DecoderTestColumnHandle column5 = new DecoderTestColumnHandle(0, "column5", (Type)DoubleType.DOUBLE, "4", null, null, false, false, false);
        DecoderTestColumnHandle column6 = new DecoderTestColumnHandle(0, "column6", (Type)BooleanType.BOOLEAN, "5", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column1, (Object)column2, (Object)column3, (Object)column4, (Object)column5, (Object)column6, (Object[])new DecoderColumnHandle[0]);
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)columns);
        Map decodedRow = (Map)rowDecoder.decodeRow(csv.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        Assert.assertEquals((int)decodedRow.size(), (int)columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column1, "ala");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column2, 10L);
        DecoderTestUtil.checkIsNull(decodedRow, column3);
        DecoderTestUtil.checkIsNull(decodedRow, column4);
        DecoderTestUtil.checkIsNull(decodedRow, column5);
        DecoderTestUtil.checkIsNull(decodedRow, column6);
    }

    @Test
    public void testWrongMappingDefined() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, null, null, null, false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("mapping not defined for column 'column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "x", null, null, false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("invalid mapping 'x' for column 'column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "-1", null, null, false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("invalid mapping '-1' for column 'column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "1:1", null, null, false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("invalid mapping '1:1' for column 'column'");
    }

    @Test
    public void testInvalidExtraneousParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "format", null, false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("unexpected data format 'format' defined for column 'column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", null, "hint", false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("unexpected format hint 'hint' defined for column 'column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", null, null, false, false, true)).isInstanceOf(PrestoException.class)).hasMessageMatching("unexpected internal column 'column'");
    }

    @Test
    public void testSupportedDataTypeValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT);
        this.singleColumnDecoder((Type)IntegerType.INTEGER);
        this.singleColumnDecoder((Type)SmallintType.SMALLINT);
        this.singleColumnDecoder((Type)TinyintType.TINYINT);
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN);
        this.singleColumnDecoder((Type)DoubleType.DOUBLE);
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType());
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)RealType.REAL));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DecimalType.createDecimalType((int)10, (int)4)));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)VarbinaryType.VARBINARY));
    }

    private void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(PrestoException.class)).hasMessageMatching("Unsupported column type .* for column .*");
    }

    private void singleColumnDecoder(Type columnType) {
        this.singleColumnDecoder(columnType, "0", null, null, false, false, false);
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat, String formatHint, boolean keyDecoder, boolean hidden, boolean internal) {
        DECODER_FACTORY.create(Collections.emptyMap(), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "column", columnType, mapping, dataFormat, formatHint, keyDecoder, hidden, internal)));
    }

    @Test
    public void testRuntimeDecodingFailure() {
        this.assertRuntimeDecodingFailure(() -> this.fieldValueDecoderFor(BigintType.BIGINT, "blah").getLong());
    }

    private FieldValueProvider fieldValueDecoderFor(BigintType type, String csv) {
        DecoderTestColumnHandle column = new DecoderTestColumnHandle(0, "column", (Type)type, "0", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column);
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)columns);
        Map decodedRow = (Map)rowDecoder.decodeRow(csv.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        return (FieldValueProvider)decodedRow.get(column);
    }

    private void assertRuntimeDecodingFailure(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(PrestoException.class)).hasMessageMatching("could not parse value .* as .* for column .*");
    }
}

