/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.prestosql.decoder.DecoderTestColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.json.JsonRowDecoderFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;
import org.testng.Assert;

public class JsonFieldDecoderTester {
    private static final JsonRowDecoderFactory DECODER_FACTORY = new JsonRowDecoderFactory(new ObjectMapperProvider().get());
    private Optional<String> dataFormat;
    private Optional<String> formatHint;

    public JsonFieldDecoderTester() {
        this(Optional.empty(), Optional.empty());
    }

    public JsonFieldDecoderTester(String dataFormat) {
        this(Optional.of(dataFormat), Optional.empty());
    }

    public JsonFieldDecoderTester(String dataFormat, String formatHint) {
        this(Optional.of(dataFormat), Optional.of(formatHint));
    }

    private JsonFieldDecoderTester(Optional<String> dataFormat, Optional<String> formatHint) {
        this.dataFormat = Objects.requireNonNull(dataFormat, "dataFormat is null");
        this.formatHint = Objects.requireNonNull(formatHint, "formatHint is null");
    }

    public void assertDecodedAs(String jsonValue, Type type, long expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Long.TYPE ? 1 : 0) != 0, (String)"Wrong (not long based) presto type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        Assert.assertFalse((boolean)decodedValue.isNull(), (String)String.format("expected non null when decoding %s as %s", jsonValue, type));
        Assert.assertEquals((long)decodedValue.getLong(), (long)expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, double expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Double.TYPE ? 1 : 0) != 0, (String)"Wrong (not double based) presto type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        Assert.assertFalse((boolean)decodedValue.isNull(), (String)String.format("expected non null when decoding %s as %s", jsonValue, type));
        Assert.assertEquals((Object)decodedValue.getDouble(), (Object)expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, Slice expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Slice.class ? 1 : 0) != 0, (String)"Wrong (not Slice based) presto type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        Assert.assertFalse((boolean)decodedValue.isNull(), (String)String.format("expected non null when decoding %s as %s", jsonValue, type));
        Assert.assertEquals((Object)decodedValue.getSlice(), (Object)expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, boolean expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Wrong (not boolean based) presto type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        Assert.assertFalse((boolean)decodedValue.isNull(), (String)String.format("expected non null when decoding %s as %s", jsonValue, type));
        Assert.assertEquals((boolean)decodedValue.getBoolean(), (boolean)expectedValue);
    }

    public void assertDecodedAsNull(String jsonValue, Type type) {
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        Assert.assertTrue((boolean)decodedValue.isNull(), (String)String.format("expected null when decoding %s as %s", jsonValue, type));
    }

    public void assertMissingDecodedAsNull(Type type) {
        FieldValueProvider decodedValue = this.decode(Optional.empty(), type);
        Assert.assertTrue((boolean)decodedValue.isNull(), (String)String.format("expected null when decoding missing field as %s", type));
    }

    public void assertInvalidInput(String jsonValue, Type type, String exceptionRegex) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decode(Optional.of(jsonValue), type).getLong()).isInstanceOf(PrestoException.class)).hasMessageMatching(exceptionRegex);
    }

    private FieldValueProvider decode(Optional<String> jsonValue, Type type) {
        String jsonField = "value";
        String json = jsonValue.map(value -> String.format("{\"%s\":%s}", jsonField, value)).orElse("{}");
        DecoderTestColumnHandle columnHandle = new DecoderTestColumnHandle(0, "some_column", type, jsonField, this.dataFormat.orElse(null), this.formatHint.orElse(null), false, false, false);
        RowDecoder rowDecoder = DECODER_FACTORY.create(Collections.emptyMap(), (Set)ImmutableSet.of((Object)columnHandle));
        Map decodedRow = (Map)rowDecoder.decodeRow(json.getBytes(StandardCharsets.UTF_8), null).orElseThrow(AssertionError::new);
        Assert.assertTrue((boolean)decodedRow.containsKey(columnHandle), (String)String.format("column '%s' not found in decoded row", columnHandle.getName()));
        return (FieldValueProvider)decodedRow.get(columnHandle);
    }
}

