/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.decoder.DecoderTestColumnHandle;
import io.prestosql.decoder.json.JsonFieldDecoderTester;
import io.prestosql.decoder.json.JsonRowDecoderFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCustomDateTimeJsonFieldDecoder {
    private final JsonFieldDecoderTester timestampTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd H:m:s");
    private final JsonFieldDecoderTester timestampWithTimeZoneTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd H:m:s Z");
    private final JsonFieldDecoderTester timeTester = new JsonFieldDecoderTester("custom-date-time", "mm:HH:ss");
    private final JsonFieldDecoderTester dateTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd");
    private final JsonFieldDecoderTester timeJustHourTester = new JsonFieldDecoderTester("custom-date-time", "HH");

    @Test
    public void testDecode() {
        this.timestampTester.assertDecodedAs("\"02/2018/19 9:20:11\"", (Type)TimestampType.TIMESTAMP, 1519032011000L);
        this.timestampWithTimeZoneTester.assertDecodedAs("\"02/2018/19 11:20:11 +02:00\"", (Type)TimestampType.TIMESTAMP, 1519032011000L);
        this.timestampTester.assertDecodedAs("\"02/2018/19 9:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.timestampWithTimeZoneTester.assertDecodedAs("\"02/2018/19 11:20:11 +02:00\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.timeTester.assertDecodedAs("\"15:13:18\"", (Type)TimeType.TIME, 47718000L);
        this.timeJustHourTester.assertDecodedAs("\"15\"", (Type)TimeType.TIME, 54000000L);
        this.timeJustHourTester.assertDecodedAs("15", (Type)TimeType.TIME, 54000000L);
        this.timeTester.assertDecodedAs("\"15:13:18\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)47718000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.dateTester.assertDecodedAs("\"02/2018/11\"", (Type)DateType.DATE, 17573L);
    }

    @Test
    public void testDecodeNulls() {
        this.dateTester.assertDecodedAsNull("null", (Type)DateType.DATE);
        this.dateTester.assertMissingDecodedAsNull((Type)DateType.DATE);
        this.timeTester.assertDecodedAsNull("null", (Type)TimeType.TIME);
        this.timeTester.assertMissingDecodedAsNull((Type)TimeType.TIME);
        this.timeTester.assertDecodedAsNull("null", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.timeTester.assertMissingDecodedAsNull((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.timestampTester.assertDecodedAsNull("null", (Type)TimestampType.TIMESTAMP);
        this.timestampTester.assertMissingDecodedAsNull((Type)TimestampType.TIMESTAMP);
        this.timestampTester.assertDecodedAsNull("null", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.timestampTester.assertMissingDecodedAsNull((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    }

    @Test
    public void testDecodeInvalid() {
        this.timestampTester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP, "could not parse value '1' as 'timestamp' for column 'some_column'");
        this.timestampTester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP, "could not parse non-value node as 'timestamp' for column 'some_column'");
        this.timestampTester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP, "could not parse value 'a' as 'timestamp' for column 'some_column'");
        this.timestampTester.assertInvalidInput("\"15:13:18\"", (Type)TimestampType.TIMESTAMP, "could not parse value '15:13:18' as 'timestamp' for column 'some_column'");
        this.timestampTester.assertInvalidInput("\"02/2018/11\"", (Type)TimestampType.TIMESTAMP, "could not parse value '02/2018/11' as 'timestamp' for column 'some_column'");
    }

    @Test
    public void testInvalidFormatHint() {
        DecoderTestColumnHandle columnHandle = new DecoderTestColumnHandle(0, "some_column", (Type)TimestampType.TIMESTAMP, "mappedField", "custom-date-time", "XXMM/yyyy/dd H:m:sXX", false, false, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new JsonRowDecoderFactory(new ObjectMapperProvider().get()).create(Collections.emptyMap(), (Set)ImmutableSet.of((Object)columnHandle))).isInstanceOf(PrestoException.class)).hasMessageMatching("invalid joda pattern 'XXMM/yyyy/dd H:m:sXX' passed as format hint for column 'some_column'");
    }
}

