/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import io.prestosql.decoder.json.JsonFieldDecoderTester;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import java.math.BigInteger;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestDefaultJsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester();

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("0.5", (Type)DoubleType.DOUBLE, 0.5);
        this.tester.assertDecodedAs("-0.5", (Type)DoubleType.DOUBLE, -0.5);
        this.tester.assertDecodedAs("10", (Type)DoubleType.DOUBLE, 10.0);
        this.tester.assertDecodedAs("0", (Type)DoubleType.DOUBLE, 0.0);
        this.tester.assertDecodedAs("\"0.4\"", (Type)DoubleType.DOUBLE, 0.4);
        this.tester.assertDecodedAs("-128", (Type)TinyintType.TINYINT, -128L);
        this.tester.assertDecodedAs("127", (Type)TinyintType.TINYINT, 127L);
        this.tester.assertDecodedAs("0", (Type)TinyintType.TINYINT, 0L);
        this.tester.assertDecodedAs("\"10\"", (Type)TinyintType.TINYINT, 10L);
        this.assertCouldNotParse("-129", (Type)TinyintType.TINYINT);
        this.assertCouldNotParse("128", (Type)TinyintType.TINYINT);
        this.tester.assertDecodedAs("-32768", (Type)SmallintType.SMALLINT, -32768L);
        this.tester.assertDecodedAs("32767", (Type)SmallintType.SMALLINT, 32767L);
        this.tester.assertDecodedAs("0", (Type)SmallintType.SMALLINT, 0L);
        this.tester.assertDecodedAs("\"1000\"", (Type)SmallintType.SMALLINT, 1000L);
        this.assertCouldNotParse("-32769", (Type)SmallintType.SMALLINT);
        this.assertCouldNotParse("32768", (Type)SmallintType.SMALLINT);
        this.tester.assertDecodedAs("-2147483648", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        this.tester.assertDecodedAs("2147483647", (Type)IntegerType.INTEGER, Integer.MAX_VALUE);
        this.tester.assertDecodedAs("0", (Type)IntegerType.INTEGER, 0L);
        this.tester.assertDecodedAs("\"1000\"", (Type)IntegerType.INTEGER, 1000L);
        this.assertCouldNotParse("-2147483649", (Type)IntegerType.INTEGER);
        this.assertCouldNotParse("2147483648", (Type)IntegerType.INTEGER);
        this.tester.assertDecodedAs("-9223372036854775808", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.tester.assertDecodedAs("9223372036854775807", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        this.tester.assertDecodedAs("0", (Type)BigintType.BIGINT, 0L);
        this.tester.assertDecodedAs("\"1000\"", (Type)BigintType.BIGINT, 1000L);
        this.assertCouldNotParse("" + BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE), (Type)BigintType.BIGINT);
        this.assertCouldNotParse("" + BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE), (Type)BigintType.BIGINT);
        this.tester.assertDecodedAs("false", (Type)BooleanType.BOOLEAN, false);
        this.tester.assertDecodedAs("true", (Type)BooleanType.BOOLEAN, true);
        this.tester.assertDecodedAs("\"false\"", (Type)BooleanType.BOOLEAN, false);
        this.tester.assertDecodedAs("\"true\"", (Type)BooleanType.BOOLEAN, true);
        this.tester.assertDecodedAs("\"blah\"", (Type)BooleanType.BOOLEAN, false);
        this.tester.assertDecodedAs("0", (Type)BooleanType.BOOLEAN, false);
        this.tester.assertDecodedAs("1", (Type)BooleanType.BOOLEAN, true);
        this.tester.assertDecodedAs("10", (Type)BooleanType.BOOLEAN, true);
        this.tester.assertDecodedAs("\"0\"", (Type)BooleanType.BOOLEAN, false);
        this.tester.assertDecodedAs("\"1\"", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void decodeNonValue() {
        for (Type type : Arrays.asList(TinyintType.TINYINT, SmallintType.SMALLINT, IntegerType.INTEGER, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN)) {
            this.assertCouldNotParse("{}", type);
            this.assertCouldNotParse("[]", type);
        }
    }

    private void assertCouldNotParse(String jsonValue, Type type) {
        this.tester.assertInvalidInput(jsonValue, type, ".*could not parse.*");
    }
}

