/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import io.prestosql.decoder.json.JsonFieldDecoderTester;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestISO8601JsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("iso8601");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11\"", (Type)TimestampType.TIMESTAMP, 1519032011000L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11Z\"", (Type)TimestampType.TIMESTAMP, 1519032011000L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11+10:00\"", (Type)TimestampType.TIMESTAMP, 1519032011000L);
        this.tester.assertDecodedAs("\"13:15:18\"", (Type)TimeType.TIME, 47718000L);
        this.tester.assertDecodedAs("\"13:15\"", (Type)TimeType.TIME, 47700000L);
        this.tester.assertDecodedAs("\"13:15:18Z\"", (Type)TimeType.TIME, 47718000L);
        this.tester.assertDecodedAs("\"13:15Z\"", (Type)TimeType.TIME, 47700000L);
        this.tester.assertDecodedAs("\"13:15:18+10:00\"", (Type)TimeType.TIME, 47718000L);
        this.tester.assertDecodedAs("\"13:15+10:00\"", (Type)TimeType.TIME, 47700000L);
        this.tester.assertDecodedAs("\"2018-02-11\"", (Type)DateType.DATE, 17573L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11Z\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"2018-02-19T12:20:11+03:00\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (String)"+03:00"));
        this.tester.assertDecodedAs("\"13:15:18Z\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)47718000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"13:15:18+10:00\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)47718000L, (String)"+10:00"));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(DateType.DATE, TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        this.tester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP, "could not parse value '1' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP, "could not parse non-value node as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP, "could not parse value 'a' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP, "could not parse value '1' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)DateType.DATE, "could not parse value '2018-02-19T09:20:11' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)DateType.DATE, "could not parse value '2018-02-19T09:20:11Z' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11Z\"", (Type)DateType.DATE, "could not parse value '09:20:11Z' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)DateType.DATE, "could not parse value '09:20:11' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "could not parse value '2018-02-19T09:20:11' as 'timestamp with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "could not parse value '09:20:11' as 'timestamp with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11Z\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "could not parse value '09:20:11Z' as 'timestamp with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "could not parse value '2018-02-19' as 'timestamp with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimeType.TIME, "could not parse value '2018-02-19T09:20:11' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)TimeType.TIME, "could not parse value '2018-02-19T09:20:11Z' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimeType.TIME, "could not parse value '2018-02-19' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19Z\"", (Type)TimeType.TIME, "could not parse value '2018-02-19Z' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '2018-02-19T09:20:11' as 'time with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '2018-02-19T09:20:11Z' as 'time with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '09:20:11' as 'time with time zone' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '2018-02-19' as 'time with time zone' for column 'some_column'");
    }
}

