/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import io.prestosql.decoder.json.JsonFieldDecoderTester;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestRFC2822JsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("rfc2822");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("\"Mon Feb 12 13:15:16 Z 2018\"", (Type)DateType.DATE, 17574L);
        this.tester.assertDecodedAs("\"Thu Jan 01 13:15:19 Z 1970\"", (Type)TimeType.TIME, 47719000L);
        this.tester.assertDecodedAs("\"Thu Jan 01 13:15:19 Z 1970\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)47719000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"Fri Feb 09 13:15:19 Z 2018\"", (Type)TimestampType.TIMESTAMP, 1518182119000L);
        this.tester.assertDecodedAs("\"Fri Feb 09 13:15:19 Z 2018\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1518182119000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"Fri Feb 09 15:15:19 +02:00 2018\"", (Type)TimestampType.TIMESTAMP, 1518182119000L);
        this.tester.assertDecodedAs("\"Fri Feb 09 15:15:19 +02:00 2018\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1518182119000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(DateType.DATE, TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        this.tester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP, "could not parse non-value node as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP, "could not parse value 'a' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("2018", (Type)TimestampType.TIMESTAMP, "could not parse value '2018' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 12 13:15:16 Z\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 12 13:15:16 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 12 Z 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon 12 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Feb 12 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Fri Feb 09 13:15:19 Europe/Warsaw 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
        this.tester.assertInvalidInput("\"Fri Feb 09 13:15:19 EST 2018\"", (Type)TimestampType.TIMESTAMP, "could not parse value '.*' as 'timestamp' for column 'some_column'");
    }
}

