/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import io.prestosql.decoder.json.JsonFieldDecoderTester;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestSecondsSinceEpochJsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("seconds-since-epoch");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("33701", (Type)TimeType.TIME, 33701000L);
        this.tester.assertDecodedAs("\"33701\"", (Type)TimeType.TIME, 33701000L);
        this.tester.assertDecodedAs("33701", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)33701000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"33701\"", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)33701000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("1519032101", (Type)TimestampType.TIMESTAMP, 1519032101000L);
        this.tester.assertDecodedAs("\"1519032101\"", (Type)TimestampType.TIMESTAMP, 1519032101000L);
        this.tester.assertDecodedAs("9223372036854775", (Type)TimestampType.TIMESTAMP, 9223372036854775000L);
        this.tester.assertDecodedAs("-9223372036854775", (Type)TimestampType.TIMESTAMP, -9223372036854775000L);
        this.tester.assertDecodedAs("1519032101", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032101000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"1519032101\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeEncoding.packDateTimeWithZone((long)1519032101000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        for (Type type : Arrays.asList(TimeType.TIME, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, TimestampType.TIMESTAMP, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            this.tester.assertInvalidInput("{}", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("[]", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("[10]", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("\"a\"", type, "could not parse value 'a' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("12345678901234567890", type, "could not parse value '12345678901234567890' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("9223372036854776", type, "could not parse value '9223372036854776' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("-9223372036854776", type, "could not parse value '-9223372036854776' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("362016000.5", type, "could not parse value '3.620160005E8' as '.*' for column 'some_column'");
        }
        this.tester.assertInvalidInput("-1", (Type)TimeType.TIME, "could not parse value '-1' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput(TimeUnit.DAYS.toSeconds(1L) + "1", (Type)TimeType.TIME, "could not parse value '864001' as 'time' for column 'some_column'");
        this.tester.assertInvalidInput("-1", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '-1' as 'time with time zone' for column 'some_column'");
        this.tester.assertInvalidInput(TimeUnit.DAYS.toSeconds(1L) + "1", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "could not parse value '864001' as 'time with time zone' for column 'some_column'");
    }
}

