/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.DocumentLinkResolver;
import io.prismic.Fragment;
import io.prismic.FragmentParser;
import io.prismic.LinkedDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document {
    private final String id;
    private final String href;
    private final Set<String> tags;
    private final List<String> slugs;
    private final String type;
    private final Map<String, Fragment> fragments;
    private final List<LinkedDocument> linkedDocuments;

    public Document(String id, String type, String href, Set<String> tags, List<String> slugs, List<LinkedDocument> linkedDocuments, Map<String, Fragment> fragments) {
        this.id = id;
        this.type = type;
        this.href = href;
        this.tags = Collections.unmodifiableSet(tags);
        this.slugs = Collections.unmodifiableList(slugs);
        this.fragments = Collections.unmodifiableMap(fragments);
        this.linkedDocuments = Collections.unmodifiableList(linkedDocuments);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<String> getSlugs() {
        return this.slugs;
    }

    public String getSlug() {
        if (this.slugs.size() > 0) {
            return this.slugs.get(0);
        }
        return null;
    }

    public List<LinkedDocument> getLinkedDocuments() {
        return this.linkedDocuments;
    }

    public Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public Fragment get(String field) {
        List<Fragment> multi;
        Fragment single = this.fragments.get(field);
        if (single == null && (multi = this.getAll(field)).size() > 0) {
            single = multi.get(0);
        }
        return single;
    }

    public List<Fragment> getAll(String field) {
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (Map.Entry<String, Fragment> entry : this.fragments.entrySet()) {
            if (!entry.getKey().matches("\\Q" + field + "\\E\\[\\d+\\]")) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public Fragment.Image getImage(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Image) {
            return (Fragment.Image)fragment;
        }
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Image)) continue;
                return new Fragment.Image(((Fragment.StructuredText.Block.Image)block).getView());
            }
        }
        return null;
    }

    public List<Fragment.Image> getAllImages(String field) {
        List<Fragment> fragments = this.getAll(field);
        ArrayList<Fragment.Image> images = new ArrayList<Fragment.Image>();
        for (Fragment fragment : fragments) {
            if (fragment != null && fragment instanceof Fragment.Image) {
                images.add((Fragment.Image)fragment);
                continue;
            }
            if (fragment == null || !(fragment instanceof Fragment.StructuredText)) continue;
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Image)) continue;
                images.add(new Fragment.Image(((Fragment.StructuredText.Block.Image)block).getView()));
            }
        }
        return images;
    }

    public Fragment.Image.View getImage(String field, String view) {
        Fragment.Image image = this.getImage(field);
        if (image != null) {
            return image.getView(view);
        }
        return null;
    }

    public List<Fragment.Image.View> getAllImages(String field, String view) {
        ArrayList<Fragment.Image.View> views = new ArrayList<Fragment.Image.View>();
        for (Fragment.Image image : this.getAllImages(field)) {
            Fragment.Image.View imageView = image.getView(view);
            if (imageView == null) continue;
            views.add(imageView);
        }
        return views;
    }

    public Fragment.StructuredText getStructuredText(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            return (Fragment.StructuredText)fragment;
        }
        return null;
    }

    public String getHtml(String field, DocumentLinkResolver linkResolver) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            return ((Fragment.StructuredText)fragment).asHtml(linkResolver);
        }
        if (fragment != null && fragment instanceof Fragment.Number) {
            return ((Fragment.Number)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Color) {
            return ((Fragment.Color)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Text) {
            return ((Fragment.Text)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Date) {
            return ((Fragment.Date)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Embed) {
            return ((Fragment.Embed)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.Image) {
            return ((Fragment.Image)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.WebLink) {
            return ((Fragment.WebLink)fragment).asHtml();
        }
        if (fragment != null && fragment instanceof Fragment.DocumentLink) {
            return ((Fragment.DocumentLink)fragment).asHtml(linkResolver);
        }
        if (fragment != null && fragment instanceof Fragment.Group) {
            return ((Fragment.Group)fragment).asHtml(linkResolver);
        }
        return "";
    }

    public String getText(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.StructuredText) {
            StringBuilder text = new StringBuilder();
            for (Fragment.StructuredText.Block block : ((Fragment.StructuredText)fragment).getBlocks()) {
                if (!(block instanceof Fragment.StructuredText.Block.Text)) continue;
                text.append(((Fragment.StructuredText.Block.Text)block).getText());
                text.append("\n");
            }
            return text.toString().trim();
        }
        if (fragment != null && fragment instanceof Fragment.Number) {
            return ((Fragment.Number)fragment).getValue().toString();
        }
        if (fragment != null && fragment instanceof Fragment.Color) {
            return ((Fragment.Color)fragment).getHexValue();
        }
        if (fragment != null && fragment instanceof Fragment.Text) {
            return ((Fragment.Text)fragment).getValue();
        }
        if (fragment != null && fragment instanceof Fragment.Date) {
            return ((Fragment.Date)fragment).getValue().toString();
        }
        return "";
    }

    public Fragment.Color getColor(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Color) {
            return (Fragment.Color)fragment;
        }
        return null;
    }

    public Fragment.Number getNumber(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Number) {
            return (Fragment.Number)fragment;
        }
        return null;
    }

    public Fragment.Date getDate(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Date) {
            return (Fragment.Date)fragment;
        }
        return null;
    }

    public Fragment.GeoPoint getGeoPoint(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.GeoPoint) {
            return (Fragment.GeoPoint)fragment;
        }
        return null;
    }

    public String getDate(String field, String pattern) {
        Fragment.Date date = this.getDate(field);
        if (date != null) {
            return date.asText(pattern);
        }
        return null;
    }

    public String getNumber(String field, String pattern) {
        Fragment.Number number = this.getNumber(field);
        if (number != null) {
            return number.asText(pattern);
        }
        return null;
    }

    public boolean getBoolean(String field) {
        String value;
        Fragment fragment = this.get(field);
        return fragment != null && fragment instanceof Fragment.Text && ("yes".equals(value = ((Fragment.Text)fragment).getValue().toLowerCase()) || "true".equals(value));
    }

    public Fragment.Group getGroup(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Group) {
            return (Fragment.Group)fragment;
        }
        return null;
    }

    public String asHtml(DocumentLinkResolver linkResolver) {
        StringBuilder html = new StringBuilder();
        for (Map.Entry<String, Fragment> fragment : this.fragments.entrySet()) {
            html.append("<section data-field=\"" + fragment.getKey() + "\">");
            html.append(this.getHtml(fragment.getKey(), linkResolver));
            html.append("</section>\n");
        }
        return html.toString().trim();
    }

    public String toString() {
        return "Document#" + this.id + " [" + this.type + "]";
    }

    static Document parse(JsonNode json, FragmentParser fragmentParser) {
        String id = json.path("id").asText();
        String href = json.path("href").asText();
        String type = json.path("type").asText();
        Iterator tagsJson = json.withArray("tags").elements();
        HashSet<String> tags = new HashSet<String>();
        while (tagsJson.hasNext()) {
            tags.add(((JsonNode)tagsJson.next()).asText());
        }
        Iterator slugsJson = json.withArray("slugs").elements();
        ArrayList<String> slugs = new ArrayList<String>();
        while (slugsJson.hasNext()) {
            slugs.add(((JsonNode)slugsJson.next()).asText());
        }
        ArrayList<LinkedDocument> linkedDocuments = new ArrayList<LinkedDocument>();
        if (json.has("linked_documents")) {
            Iterator linkedDocumentsJson = json.withArray("linked_documents").elements();
            while (linkedDocumentsJson.hasNext()) {
                LinkedDocument linkedDocument = LinkedDocument.parse((JsonNode)linkedDocumentsJson.next());
                linkedDocuments.add(linkedDocument);
            }
        }
        Iterator dataJson = json.with("data").with(type).fieldNames();
        LinkedHashMap<String, Fragment> fragments = new LinkedHashMap<String, Fragment>();
        while (dataJson.hasNext()) {
            JsonNode fragmentValue;
            String field = (String)dataJson.next();
            JsonNode fieldJson = json.with("data").with(type).path(field);
            if (fieldJson.isArray()) {
                for (int i = 0; i < fieldJson.size(); ++i) {
                    JsonNode fragmentValue2;
                    String fragmentName = type + "." + field + "[" + i + "]";
                    String fragmentType = fieldJson.path(i).path("type").asText();
                    Fragment fragment = fragmentParser.parse(fragmentType, fragmentValue2 = fieldJson.path(i).path("value"));
                    if (fragment == null) continue;
                    fragments.put(fragmentName, fragment);
                }
                continue;
            }
            String fragmentName = type + "." + field;
            String fragmentType = fieldJson.path("type").asText();
            Fragment fragment = fragmentParser.parse(fragmentType, fragmentValue = fieldJson.path("value"));
            if (fragment == null) continue;
            fragments.put(fragmentName, fragment);
        }
        return new Document(id, type, href, tags, slugs, linkedDocuments, fragments);
    }
}

