/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.DocumentLinkResolver;
import io.prismic.FragmentParser;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public interface Fragment {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group
    implements Fragment {
        private final List<Map<String, Fragment>> fragmentMapList;

        public Group(List<Map<String, Fragment>> fragmentMapList) {
            this.fragmentMapList = fragmentMapList;
        }

        public List<Map<String, Fragment>> toMapList() {
            return this.fragmentMapList;
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            StringBuffer sb = new StringBuffer();
            for (Map<String, Fragment> fragmentMap : this.fragmentMapList) {
                for (String fragmentName : fragmentMap.keySet()) {
                    sb.append("<section data-field=\"" + fragmentName + "\">");
                    Fragment fragment = fragmentMap.get(fragmentName);
                    if (fragment != null && fragment instanceof StructuredText) {
                        sb.append(((StructuredText)fragment).asHtml(linkResolver));
                    } else if (fragment != null && fragment instanceof Number) {
                        sb.append(((Number)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof Color) {
                        sb.append(((Color)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof Text) {
                        sb.append(((Text)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof Date) {
                        sb.append(((Date)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof Embed) {
                        sb.append(((Embed)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof Image) {
                        sb.append(((Image)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof WebLink) {
                        sb.append(((WebLink)fragment).asHtml());
                    } else if (fragment != null && fragment instanceof DocumentLink) {
                        sb.append(((DocumentLink)fragment).asHtml(linkResolver));
                    }
                    sb.append("</section>");
                }
            }
            return sb.toString();
        }

        static Group parse(JsonNode json, FragmentParser fragmentParser) {
            ArrayList<Map<String, Fragment>> fragmentMapList = new ArrayList<Map<String, Fragment>>();
            for (JsonNode groupJson : json) {
                Iterator dataJson = groupJson.fieldNames();
                HashMap<String, Fragment> fragmentMap = new HashMap<String, Fragment>();
                while (dataJson.hasNext()) {
                    JsonNode fragmentValue;
                    String field = (String)dataJson.next();
                    JsonNode fieldJson = groupJson.path(field);
                    String fragmentType = fieldJson.path("type").asText();
                    Fragment fragment = fragmentParser.parse(fragmentType, fragmentValue = fieldJson.path("value"));
                    if (fragment == null) continue;
                    fragmentMap.put(field, fragment);
                }
                fragmentMapList.add(fragmentMap);
            }
            return new Group(fragmentMapList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructuredText
    implements Fragment {
        final List<Block> blocks;

        public StructuredText(List<Block> blocks) {
            this.blocks = blocks;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public Block.Heading getTitle() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Heading)) continue;
                return (Block.Heading)block;
            }
            return null;
        }

        public Block.Paragraph getFirstParagraph() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Paragraph)) continue;
                return (Block.Paragraph)block;
            }
            return null;
        }

        public Block.Preformatted getFirstPreformatted() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Preformatted)) continue;
                return (Block.Preformatted)block;
            }
            return null;
        }

        public Block.Image getFirstImage() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.Image)) continue;
                return (Block.Image)block;
            }
            return null;
        }

        public String asHtml(List<Block> blocks, DocumentLinkResolver linkResolver) {
            ArrayList<BlockGroup> blockGroups = new ArrayList<BlockGroup>();
            for (Block block : blocks) {
                BlockGroup newBlockGroup;
                BlockGroup lastOne;
                BlockGroup blockGroup = lastOne = blockGroups.isEmpty() ? null : (BlockGroup)blockGroups.get(blockGroups.size() - 1);
                if (lastOne != null && "ul".equals(lastOne.tag) && block instanceof Block.ListItem && !((Block.ListItem)block).isOrdered()) {
                    lastOne.blocks.add(block);
                    continue;
                }
                if (lastOne != null && "ol".equals(lastOne.tag) && block instanceof Block.ListItem && ((Block.ListItem)block).isOrdered()) {
                    lastOne.blocks.add(block);
                    continue;
                }
                if (block instanceof Block.ListItem && !((Block.ListItem)block).isOrdered()) {
                    newBlockGroup = new BlockGroup("ul", new ArrayList<Block>());
                    newBlockGroup.blocks.add(block);
                    blockGroups.add(newBlockGroup);
                    continue;
                }
                if (block instanceof Block.ListItem && ((Block.ListItem)block).isOrdered()) {
                    newBlockGroup = new BlockGroup("ol", new ArrayList<Block>());
                    newBlockGroup.blocks.add(block);
                    blockGroups.add(newBlockGroup);
                    continue;
                }
                newBlockGroup = new BlockGroup(null, new ArrayList<Block>());
                newBlockGroup.blocks.add(block);
                blockGroups.add(newBlockGroup);
            }
            StringBuilder html = new StringBuilder();
            for (BlockGroup blockGroup : blockGroups) {
                if (blockGroup.tag != null) {
                    html.append("<" + blockGroup.tag + ">");
                    for (Block block : blockGroup.blocks) {
                        html.append(this.asHtml(block, linkResolver));
                    }
                    html.append("</" + blockGroup.tag + ">");
                    continue;
                }
                for (Block block : blockGroup.blocks) {
                    html.append(this.asHtml(block, linkResolver));
                }
            }
            return html.toString();
        }

        public String asHtml(Block block, DocumentLinkResolver linkResolver) {
            if (block instanceof Block.Heading) {
                Block.Heading heading = (Block.Heading)block;
                return "<h" + heading.getLevel() + ">" + this.asHtml(heading.getText(), heading.getSpans(), linkResolver) + "</h" + heading.getLevel() + ">";
            }
            if (block instanceof Block.Paragraph) {
                Block.Paragraph paragraph = (Block.Paragraph)block;
                return "<p>" + this.asHtml(paragraph.getText(), paragraph.getSpans(), linkResolver) + "</p>";
            }
            if (block instanceof Block.Preformatted) {
                Block.Preformatted paragraph = (Block.Preformatted)block;
                return "<pre>" + this.asHtml(paragraph.getText(), paragraph.getSpans(), linkResolver) + "</pre>";
            }
            if (block instanceof Block.ListItem) {
                Block.ListItem listItem = (Block.ListItem)block;
                return "<li>" + this.asHtml(listItem.getText(), listItem.getSpans(), linkResolver) + "</li>";
            }
            if (block instanceof Block.Image) {
                Block.Image image = (Block.Image)block;
                return "<p>" + image.getView().asHtml() + "</p>";
            }
            if (block instanceof Block.Embed) {
                Block.Embed embed = (Block.Embed)block;
                return embed.getObj().asHtml();
            }
            return "";
        }

        private Tuple<String, String> getStartAndEnd(Span span, DocumentLinkResolver linkResolver) {
            if (span instanceof Span.Strong) {
                return new Tuple<String, String>("<strong>", "</strong>");
            }
            if (span instanceof Span.Em) {
                return new Tuple<String, String>("<em>", "</em>");
            }
            if (span instanceof Span.Hyperlink) {
                Span.Hyperlink hyperlink = (Span.Hyperlink)span;
                if (hyperlink.link instanceof WebLink) {
                    WebLink webLink = (WebLink)hyperlink.getLink();
                    return new Tuple<String, String>("<a href=\"" + webLink.getUrl() + "\">", "</a>");
                }
                if (hyperlink.link instanceof FileLink) {
                    FileLink fileLink = (FileLink)hyperlink.getLink();
                    return new Tuple<String, String>("<a href=\"" + fileLink.getUrl() + "\">", "</a>");
                }
                if (hyperlink.link instanceof ImageLink) {
                    ImageLink imageLink = (ImageLink)hyperlink.getLink();
                    return new Tuple<String, String>("<a href=\"" + imageLink.getUrl() + "\">", "</a>");
                }
                if (hyperlink.link instanceof DocumentLink) {
                    DocumentLink documentLink = (DocumentLink)hyperlink.getLink();
                    String url = linkResolver.resolveLink(documentLink);
                    return new Tuple<String, String>("<a " + (linkResolver.getTitle(documentLink) == null ? "" : "title=\"" + linkResolver.getTitle(documentLink) + "\" ") + "href=\"" + url + "\">", "</a>");
                }
            }
            return new Tuple<String, String>("", "");
        }

        Integer peekStart(Stack<Span> span) {
            return span.empty() ? Integer.MAX_VALUE : span.peek().getStart();
        }

        Integer peekEnd(Stack<Span> span) {
            return span.empty() ? Integer.MAX_VALUE : span.peek().getEnd();
        }

        public String asHtml(String text, List<Span> spans, DocumentLinkResolver linkResolver) {
            Stack<Span> starts = new Stack<Span>();
            for (int i = spans.size() - 1; i >= 0; --i) {
                starts.add(spans.get(i));
            }
            Stack<Span> endings = new Stack<Span>();
            StringBuffer result = new StringBuffer();
            Integer pos = 0;
            if (!spans.isEmpty()) {
                while (!starts.empty() || !endings.empty()) {
                    int next = Math.min(this.peekStart(starts), this.peekEnd(endings));
                    if (next > pos) {
                        result.append(text.substring(0, next - pos));
                        text = text.substring(next - pos);
                        pos = next;
                        continue;
                    }
                    StringBuffer spansToApply = new StringBuffer();
                    while (Math.min(this.peekStart(starts), this.peekEnd(endings)) == pos) {
                        if (!endings.empty() && endings.peek().getEnd() == pos.intValue()) {
                            spansToApply.append((String)this.getStartAndEnd((Span)endings.pop(), (DocumentLinkResolver)linkResolver).y);
                            continue;
                        }
                        if (starts.empty() || starts.peek().getStart() != pos.intValue()) continue;
                        Span start = starts.pop();
                        endings.push(start);
                        spansToApply.append((String)this.getStartAndEnd((Span)start, (DocumentLinkResolver)linkResolver).x);
                    }
                    result.append(spansToApply);
                }
                return result.toString() + (text.length() > 0 ? text : "");
            }
            return text;
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            return this.asHtml(this.getBlocks(), linkResolver);
        }

        static Span parseSpan(JsonNode json) {
            String type = json.path("type").asText();
            int start = json.path("start").intValue();
            int end = json.path("end").intValue();
            JsonNode data = json.with("data");
            if (end > start) {
                if ("strong".equals(type)) {
                    return new Span.Strong(start, end);
                }
                if ("em".equals(type)) {
                    return new Span.Em(start, end);
                }
                if ("hyperlink".equals(type)) {
                    String linkType = data.path("type").asText();
                    JsonNode value = data.with("value");
                    Link link = null;
                    if ("Link.web".equals(linkType)) {
                        link = WebLink.parse(value);
                    } else if ("Link.document".equals(linkType)) {
                        link = DocumentLink.parse(value);
                    } else if ("Link.file".equals(linkType)) {
                        link = FileLink.parse(value);
                    } else if ("Link.image".equals(linkType)) {
                        link = ImageLink.parse(value);
                    }
                    if (link != null) {
                        return new Span.Hyperlink(start, end, link);
                    }
                }
            }
            return null;
        }

        static ParsedText parseText(JsonNode json) {
            String text = json.path("text").asText();
            ArrayList<Span> spans = new ArrayList<Span>();
            for (JsonNode spanJson : json.withArray("spans")) {
                Span span = StructuredText.parseSpan(spanJson);
                if (span == null) continue;
                spans.add(span);
            }
            return new ParsedText(text, spans);
        }

        static Block parseBlock(JsonNode json) {
            String type = json.path("type").asText();
            if ("heading1".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 1);
            }
            if ("heading2".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 2);
            }
            if ("heading3".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 3);
            }
            if ("heading4".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Heading(p.text, p.spans, 4);
            }
            if ("paragraph".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Paragraph(p.text, p.spans);
            }
            if ("preformatted".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.Preformatted(p.text, p.spans);
            }
            if ("list-item".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.ListItem(p.text, p.spans, false);
            }
            if ("o-list-item".equals(type)) {
                ParsedText p = StructuredText.parseText(json);
                return new Block.ListItem(p.text, p.spans, true);
            }
            if ("image".equals(type)) {
                Image.View view = Image.View.parse(json);
                return new Block.Image(view);
            }
            if ("embed".equals(type)) {
                Embed obj = Embed.parse(json);
                return new Block.Embed(obj);
            }
            return null;
        }

        static StructuredText parse(JsonNode json) {
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (JsonNode blockJson : json) {
                Block block = StructuredText.parseBlock(blockJson);
                if (block == null) continue;
                blocks.add(block);
            }
            return new StructuredText(blocks);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ParsedText {
            final String text;
            final List<Span> spans;

            public ParsedText(String text, List<Span> spans) {
                this.text = text;
                this.spans = spans;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Tuple<X, Y> {
            public final X x;
            public final Y y;

            public Tuple(X x, Y y) {
                this.x = x;
                this.y = y;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class BlockGroup {
            final String tag;
            final List<Block> blocks;

            public BlockGroup(String tag, List<Block> blocks) {
                this.tag = tag;
                this.blocks = blocks;
            }
        }

        public static interface Span {
            public int getStart();

            public int getEnd();

            public static class Hyperlink
            implements Span {
                private final int start;
                private final int end;
                private final Link link;

                public Hyperlink(int start, int end, Link link) {
                    this.start = start;
                    this.end = end;
                    this.link = link;
                }

                public int getStart() {
                    return this.start;
                }

                public int getEnd() {
                    return this.end;
                }

                public Link getLink() {
                    return this.link;
                }
            }

            public static class Strong
            implements Span {
                private final int start;
                private final int end;

                public Strong(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                public int getStart() {
                    return this.start;
                }

                public int getEnd() {
                    return this.end;
                }
            }

            public static class Em
            implements Span {
                private final int start;
                private final int end;

                public Em(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                public int getStart() {
                    return this.start;
                }

                public int getEnd() {
                    return this.end;
                }
            }
        }

        public static interface Block {

            public static class Embed
            implements Block {
                private final io.prismic.Fragment$Embed obj;

                public Embed(io.prismic.Fragment$Embed obj) {
                    this.obj = obj;
                }

                public io.prismic.Fragment$Embed getObj() {
                    return this.obj;
                }
            }

            public static class Image
            implements Block {
                private final Image.View view;

                public Image(Image.View view) {
                    this.view = view;
                }

                public Image.View getView() {
                    return this.view;
                }

                public String getUrl() {
                    return this.view.getUrl();
                }

                public int getWidth() {
                    return this.view.getWidth();
                }

                public int getHeight() {
                    return this.view.getHeight();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ListItem
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final boolean ordered;

                public ListItem(String text, List<Span> spans, boolean ordered) {
                    this.text = text;
                    this.spans = spans;
                    this.ordered = ordered;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                public boolean isOrdered() {
                    return this.ordered;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Preformatted
            implements Text {
                private final String text;
                private final List<Span> spans;

                public Preformatted(String text, List<Span> spans) {
                    this.text = text;
                    this.spans = spans;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Paragraph
            implements Text {
                private final String text;
                private final List<Span> spans;

                public Paragraph(String text, List<Span> spans) {
                    this.text = text;
                    this.spans = spans;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Heading
            implements Text {
                private final String text;
                private final List<Span> spans;
                private final int level;

                public Heading(String text, List<Span> spans, int level) {
                    this.text = text;
                    this.spans = spans;
                    this.level = level;
                }

                @Override
                public String getText() {
                    return this.text;
                }

                @Override
                public List<Span> getSpans() {
                    return this.spans;
                }

                public int getLevel() {
                    return this.level;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Text
            extends Block {
                public String getText();

                public List<Span> getSpans();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Image
    implements Fragment {
        private final View main;
        private final Map<String, View> views;

        public Image(View main, Map<String, View> views) {
            this.main = main;
            this.views = views;
        }

        public Image(View main) {
            this(main, new HashMap<String, View>());
        }

        public View getView(String view) {
            if ("main".equals(view)) {
                return this.main;
            }
            return this.views.get(view);
        }

        public String asHtml() {
            return this.getView("main").asHtml();
        }

        static Image parse(JsonNode json) {
            View main = View.parse(json.with("main"));
            HashMap<String, View> views = new HashMap<String, View>();
            Iterator viewsJson = json.with("views").fieldNames();
            while (viewsJson.hasNext()) {
                String view = (String)viewsJson.next();
                views.put(view, View.parse(json.with("views").with(view)));
            }
            return new Image(main, views);
        }

        public static class View {
            private final String url;
            private final int width;
            private final int height;
            private final String alt;
            private final String copyright;

            public View(String url, int width, int height, String alt, String copyright) {
                this.url = url;
                this.width = width;
                this.height = height;
                this.alt = alt;
                this.copyright = copyright;
            }

            public String getUrl() {
                return this.url;
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }

            public String getAlt() {
                return this.alt;
            }

            public String getCopyright() {
                return this.copyright;
            }

            public double ratio() {
                return this.width / this.height;
            }

            public String asHtml() {
                return "<img src=\"" + this.url + "\" width=\"" + this.width + "\" height=\"" + this.height + "\" alt=\"" + this.alt + "\">";
            }

            static View parse(JsonNode json) {
                String url = json.path("url").asText();
                int width = json.with("dimensions").path("width").intValue();
                int height = json.with("dimensions").path("height").intValue();
                String alt = json.path("alt").asText();
                String copyright = json.path("copyright").asText();
                return new View(url, width, height, alt, copyright);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocumentLink
    implements Link {
        private final String id;
        private final String type;
        private final Set<String> tags;
        private final String slug;
        private final boolean broken;

        public DocumentLink(String id, String type, Set<String> tags, String slug, boolean broken) {
            this.id = id;
            this.type = type;
            this.tags = tags;
            this.slug = slug;
            this.broken = broken;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public String getSlug() {
            return this.slug;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public String asHtml(DocumentLinkResolver linkResolver) {
            return "<a " + (linkResolver.getTitle(this) == null ? "" : "title=\"" + linkResolver.getTitle(this) + "\" ") + "href=\"" + linkResolver.resolve(this) + "\">" + this.slug + "</a>";
        }

        static DocumentLink parse(JsonNode json) {
            JsonNode document = json.with("document");
            boolean broken = json.path("isBroken").booleanValue();
            String id = document.path("id").asText();
            String type = document.path("type").asText();
            String slug = document.path("slug").asText();
            HashSet<String> tags = new HashSet<String>();
            for (JsonNode tagJson : document.withArray("tags")) {
                tags.add(tagJson.asText());
            }
            return new DocumentLink(id, type, tags, slug, broken);
        }
    }

    public static class ImageLink
    implements Link {
        private final String url;

        public ImageLink(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.url + "</a>";
        }

        static ImageLink parse(JsonNode json) {
            String url = json.path("image").path("url").asText();
            return new ImageLink(url);
        }
    }

    public static class FileLink
    implements Link {
        private final String url;
        private final String kind;
        private final Long size;
        private final String filename;

        public FileLink(String url, String kind, Long size, String filename) {
            this.url = url;
            this.kind = kind;
            this.size = size;
            this.filename = filename;
        }

        public String getUrl() {
            return this.url;
        }

        public String getKind() {
            return this.kind;
        }

        public Long getSize() {
            return this.size;
        }

        public String getFilename() {
            return this.filename;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.filename + "</a>";
        }

        static FileLink parse(JsonNode json) {
            String url = json.path("file").path("url").asText();
            String kind = json.path("file").path("kind").asText();
            String size = json.path("file").path("size").asText();
            String name = json.path("file").path("name").asText();
            return new FileLink(url, kind, Long.parseLong(size), name);
        }
    }

    public static class WebLink
    implements Link {
        private final String url;
        private final String contentType;

        public WebLink(String url, String contentType) {
            this.url = url;
            this.contentType = contentType;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String asHtml() {
            return "<a href=\"" + this.url + "\">" + this.url + "</a>";
        }

        static WebLink parse(JsonNode json) {
            String url = json.path("url").asText();
            return new WebLink(url, null);
        }
    }

    public static interface Link
    extends Fragment {
    }

    public static class Embed
    implements Fragment {
        private final String type;
        private final String provider;
        private final String url;
        private final Integer width;
        private final Integer height;
        private final String html;
        private final JsonNode oembedJson;

        public Embed(String type, String provider, String url, Integer width, Integer height, String html, JsonNode oembedJson) {
            this.type = type;
            this.provider = provider;
            this.url = url;
            this.width = width;
            this.height = height;
            this.html = html;
            this.oembedJson = oembedJson;
        }

        public String getType() {
            return this.type;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getUrl() {
            return this.url;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public String getHtml() {
            return this.html;
        }

        public JsonNode getOEmbedJson() {
            return this.oembedJson;
        }

        public String asHtml() {
            return "<div data-oembed=\"" + this.url + "\" data-oembed-type=\"" + this.type.toLowerCase() + "\" data-oembed-provider=\"" + this.provider.toLowerCase() + "\">" + this.html + "</div>";
        }

        static Embed parse(JsonNode json) {
            JsonNode oembedJson = json.with("oembed");
            String type = oembedJson.path("type").asText();
            String provider = oembedJson.path("provider_name").asText();
            String url = oembedJson.path("embed_url").asText();
            Integer width = oembedJson.has("width") && oembedJson.path("width").isNumber() ? Integer.valueOf(oembedJson.path("width").intValue()) : null;
            Integer height = oembedJson.has("height") && oembedJson.path("height").isNumber() ? Integer.valueOf(oembedJson.path("height").intValue()) : null;
            String html = oembedJson.path("html").asText();
            return new Embed(type, provider, url, width, height, html, oembedJson);
        }
    }

    public static class GeoPoint
    implements Fragment {
        private final Double latitude;
        private final Double longitude;

        public GeoPoint(Double latitude, Double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        static GeoPoint parse(JsonNode json) {
            try {
                Double latitude = json.has("latitude") && json.path("latitude").isNumber() ? Double.valueOf(json.path("latitude").doubleValue()) : null;
                Double longitude = json.has("longitude") && json.path("longitude").isNumber() ? Double.valueOf(json.path("longitude").doubleValue()) : null;
                return new GeoPoint(latitude, longitude);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Color
    implements Fragment {
        private final String hex;

        public Color(String hex) {
            this.hex = hex;
        }

        public String getHexValue() {
            return this.hex;
        }

        public String asHtml() {
            return "<span class=\"color\">" + this.hex + "</span>";
        }

        static Color parse(JsonNode json) {
            String hex = json.asText();
            if (hex.matches("#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})")) {
                return new Color(hex);
            }
            return null;
        }
    }

    public static class Number
    implements Fragment {
        private final Double value;

        public Number(Double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }

        public String asText(String pattern) {
            return new DecimalFormat(pattern).format(this.value);
        }

        public String asHtml() {
            return "<span class=\"number\">" + this.value + "</span>";
        }

        static Number parse(JsonNode json) {
            try {
                return new Number(Double.parseDouble(json.asText()));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Date
    implements Fragment {
        private final DateTime value;

        public Date(DateTime value) {
            this.value = value;
        }

        public DateTime getValue() {
            return this.value;
        }

        public String asText(String pattern) {
            return this.value.toString(pattern);
        }

        public String asHtml() {
            return "<time>" + this.value + "</time>";
        }

        static Date parse(JsonNode json) {
            try {
                return new Date(DateTime.parse((String)json.asText(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd")));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Text
    implements Fragment {
        private final String value;

        public Text(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String asHtml() {
            return "<span class=\"text\">" + this.value + "</span>";
        }

        static Text parse(JsonNode json) {
            return new Text(json.asText());
        }
    }
}

