/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Fragment;

public interface FragmentParser {
    public Fragment parse(String var1, JsonNode var2);

    public static class Default
    implements FragmentParser {
        public Fragment parse(String type, JsonNode json) {
            if ("StructuredText".equals(type)) {
                return Fragment.StructuredText.parse(json);
            }
            if ("Image".equals(type)) {
                return Fragment.Image.parse(json);
            }
            if ("Link.web".equals(type)) {
                return Fragment.WebLink.parse(json);
            }
            if ("Link.document".equals(type)) {
                return Fragment.DocumentLink.parse(json);
            }
            if ("Link.file".equals(type)) {
                return Fragment.FileLink.parse(json);
            }
            if ("Link.image".equals(type)) {
                return Fragment.ImageLink.parse(json);
            }
            if ("Text".equals(type)) {
                return Fragment.Text.parse(json);
            }
            if ("Select".equals(type)) {
                return Fragment.Text.parse(json);
            }
            if ("Date".equals(type)) {
                return Fragment.Date.parse(json);
            }
            if ("Timestamp".equals(type)) {
                return Fragment.Timestamp.parse(json);
            }
            if ("Number".equals(type)) {
                return Fragment.Number.parse(json);
            }
            if ("Color".equals(type)) {
                return Fragment.Color.parse(json);
            }
            if ("Embed".equals(type)) {
                return Fragment.Embed.parse(json);
            }
            if ("GeoPoint".equals(type)) {
                return Fragment.GeoPoint.parse(json);
            }
            if ("Group".equals(type)) {
                return Fragment.Group.parse(json, this);
            }
            return null;
        }
    }
}

