/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.Experiment;
import io.prismic.Variation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Experiments {
    private final List<Experiment> draft;
    private final List<Experiment> running;
    private List<Experiment> all = null;

    public Experiments(List<Experiment> draft, List<Experiment> running) {
        this.draft = Collections.unmodifiableList(draft);
        this.running = Collections.unmodifiableList(running);
    }

    public synchronized List<Experiment> getAll() {
        if (this.all == null) {
            this.all = new ArrayList<Experiment>();
            this.all.addAll(this.draft);
            this.all.addAll(this.running);
        }
        return this.all;
    }

    public List<Experiment> getDraft() {
        return this.draft;
    }

    public List<Experiment> getRunning() {
        return this.running;
    }

    public Experiment getCurrent() {
        if (this.running.size() > 0) {
            return this.running.get(0);
        }
        return null;
    }

    public String refFromCookie(String cookie) {
        if (cookie == null || "".equals(cookie)) {
            return null;
        }
        String[] splitted = cookie.trim().split("%20");
        if (splitted.length >= 2) {
            Experiment exp = this.findRunningById(splitted[0]);
            if (exp == null) {
                return null;
            }
            int varIndex = Integer.parseInt(splitted[1]);
            List<Variation> variations = exp.getVariations();
            if (varIndex > -1 && varIndex < variations.size()) {
                return variations.get(varIndex).getRef();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Experiments parse(JsonNode json) {
        JsonNode runningJson;
        Iterator it;
        ArrayList<Experiment> draft = new ArrayList<Experiment>();
        ArrayList<Experiment> running = new ArrayList<Experiment>();
        JsonNode draftJson = json.path("draft");
        if (!draftJson.isMissingNode()) {
            it = draftJson.elements();
            while (it.hasNext()) {
                draft.add(Experiment.parse((JsonNode)it.next()));
            }
        }
        if (!(runningJson = json.path("running")).isMissingNode()) {
            it = runningJson.elements();
            while (it.hasNext()) {
                void var3_4;
                running.add(Experiment.parse((JsonNode)var3_4.next()));
            }
        }
        return new Experiments(draft, running);
    }

    private Experiment findRunningById(String expId) {
        if (expId == null) {
            return null;
        }
        for (Experiment exp : this.running) {
            if (!expId.equals(exp.getGoogleId())) continue;
            return exp;
        }
        return null;
    }
}

