/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import io.prismic.AlternateLanguage;
import io.prismic.Fragment;
import io.prismic.WithFragments;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
extends WithFragments {
    private static final DateTimeFormatter PUBLICATION_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private final String id;
    private final String uid;
    private final String href;
    private final Set<String> tags;
    private final List<String> slugs;
    private final String type;
    private final String lang;
    private final List<AlternateLanguage> alternateLanguages;
    private final ZonedDateTime firstPublicationDate;
    private final ZonedDateTime lastPublicationDate;
    private final Map<String, Fragment> fragments;

    public Document(String id, String uid, String type, String href, Set<String> tags, List<String> slugs, String lang, List<AlternateLanguage> alternateLanguages, ZonedDateTime firstPublicationDate, ZonedDateTime lastPublicationDate, Map<String, Fragment> fragments) {
        this.id = id;
        this.uid = uid;
        this.type = type;
        this.href = href;
        this.tags = Collections.unmodifiableSet(tags);
        this.slugs = Collections.unmodifiableList(slugs);
        this.lang = lang;
        this.alternateLanguages = Collections.unmodifiableList(alternateLanguages);
        this.firstPublicationDate = firstPublicationDate;
        this.lastPublicationDate = lastPublicationDate;
        this.fragments = Collections.unmodifiableMap(fragments);
    }

    public String getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<String> getSlugs() {
        return this.slugs;
    }

    public String getSlug() {
        if (this.slugs.size() > 0) {
            return this.slugs.get(0);
        }
        return null;
    }

    public String getLang() {
        return this.lang;
    }

    public List<AlternateLanguage> getAlternateLanguages() {
        return this.alternateLanguages;
    }

    public ZonedDateTime getFirstPublicationDate() {
        return this.firstPublicationDate;
    }

    public ZonedDateTime getLastPublicationDate() {
        return this.lastPublicationDate;
    }

    @Override
    public Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public Fragment.Group getGroup(String field) {
        Fragment fragment = this.get(field);
        if (fragment != null && fragment instanceof Fragment.Group) {
            return (Fragment.Group)fragment;
        }
        return null;
    }

    public String toString() {
        return "Document#" + this.id + " [" + this.type + "]";
    }

    public Fragment.DocumentLink asDocumentLink() {
        return new Fragment.DocumentLink(this.id, this.uid, this.type, this.tags, this.getSlug(), this.lang, this.fragments, false);
    }

    static Fragment parseFragment(String type, JsonNode json) {
        switch (type) {
            case "StructuredText": {
                return Fragment.StructuredText.parse(json);
            }
            case "Image": {
                return Fragment.Image.parse(json);
            }
            case "Link.web": {
                return Fragment.WebLink.parse(json);
            }
            case "Link.document": {
                return Fragment.DocumentLink.parse(json);
            }
            case "Link.file": {
                return Fragment.FileLink.parse(json);
            }
            case "Link.image": {
                return Fragment.ImageLink.parse(json);
            }
            case "Text": {
                return Fragment.Text.parse(json);
            }
            case "Select": {
                return Fragment.Text.parse(json);
            }
            case "Date": {
                return Fragment.Date.parse(json);
            }
            case "Timestamp": {
                return Fragment.Timestamp.parse(json);
            }
            case "Number": {
                return Fragment.Number.parse(json);
            }
            case "Color": {
                return Fragment.Color.parse(json);
            }
            case "Embed": {
                return Fragment.Embed.parse(json);
            }
            case "GeoPoint": {
                return Fragment.GeoPoint.parse(json);
            }
            case "Group": {
                return Fragment.Group.parse(json);
            }
            case "SliceZone": {
                return Fragment.SliceZone.parse(json);
            }
        }
        return Fragment.Raw.parse(json);
    }

    static Map<String, Fragment> parseFragments(JsonNode json, String type) {
        Iterator dataJson = json.fieldNames();
        LinkedHashMap<String, Fragment> fragments = new LinkedHashMap<String, Fragment>();
        while (dataJson.hasNext()) {
            String field = (String)dataJson.next();
            JsonNode fieldJson = json.path(field);
            if (fieldJson.isArray()) {
                for (int i = 0; i < fieldJson.size(); ++i) {
                    String fragmentName = type + "." + field + "[" + i + "]";
                    String fragmentType = fieldJson.path(i).path("type").asText();
                    JsonNode fragmentValue = fieldJson.path(i).path("value");
                    Fragment fragment = Document.parseFragment(fragmentType, fragmentValue);
                    fragments.put(fragmentName, fragment);
                }
                continue;
            }
            String fragmentName = type + "." + field;
            String fragmentType = fieldJson.path("type").asText();
            JsonNode fragmentValue = fieldJson.path("value");
            Fragment fragment = Document.parseFragment(fragmentType, fragmentValue);
            fragments.put(fragmentName, fragment);
        }
        return fragments;
    }

    public static Document parse(JsonNode json) {
        String id = json.path("id").asText();
        String uid = json.has("uid") ? json.path("uid").asText() : null;
        String href = json.path("href").asText();
        String type = json.path("type").asText();
        String lang = json.path("lang").asText();
        ZonedDateTime firstPublicationDate = Document.parseDateTime(json.path("first_publication_date"));
        ZonedDateTime lastPublicationDate = Document.parseDateTime(json.path("last_publication_date"));
        Iterator alternateLanguagesJson = json.withArray("alternate_languages").elements();
        ArrayList<AlternateLanguage> alternateLanguages = new ArrayList<AlternateLanguage>();
        while (alternateLanguagesJson.hasNext()) {
            JsonNode altLangJson = (JsonNode)alternateLanguagesJson.next();
            String altLangId = altLangJson.path("id").asText();
            String altLangUid = altLangJson.has("uid") ? altLangJson.path("uid").asText() : null;
            String altLangType = altLangJson.path("type").asText();
            String altLangCode = altLangJson.path("lang").asText();
            alternateLanguages.add(new AlternateLanguage(altLangId, altLangUid, altLangType, altLangCode));
        }
        Iterator tagsJson = json.withArray("tags").elements();
        HashSet<String> tags = new HashSet<String>();
        while (tagsJson.hasNext()) {
            tags.add(((JsonNode)tagsJson.next()).asText());
        }
        Iterator slugsJson = json.withArray("slugs").elements();
        ArrayList<String> slugs = new ArrayList<String>();
        while (slugsJson.hasNext()) {
            try {
                slugs.add(URLDecoder.decode(((JsonNode)slugsJson.next()).asText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, Fragment> fragments = Document.parseFragments(json.with("data").with(type), type);
        return new Document(id, uid, type, href, tags, slugs, lang, alternateLanguages, firstPublicationDate, lastPublicationDate, fragments);
    }

    private static ZonedDateTime parseDateTime(JsonNode json) {
        return "null".equals(json.asText()) ? null : ZonedDateTime.parse(json.asText(), PUBLICATION_DATE_FORMATTER);
    }
}

