/*
 * Decompiled with CFR 0.152.
 */
package io.prismic;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;

public class Ref {
    private final String id;
    private final String ref;
    private final String label;
    private final boolean masterRef;
    private final ZonedDateTime scheduledAt;

    public Ref(String id, String ref, String label, boolean masterRef, ZonedDateTime scheduledAt) {
        this.id = id;
        this.ref = ref;
        this.label = label;
        this.masterRef = masterRef;
        this.scheduledAt = scheduledAt;
    }

    public String getId() {
        return this.id;
    }

    public String getRef() {
        return this.ref;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isMasterRef() {
        return this.masterRef;
    }

    public ZonedDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public String toString() {
        return "Ref: " + this.ref + (this.label != null ? " (" + this.label + ")" : "");
    }

    static Ref parse(JsonNode json) {
        String id = json.path("id").asText();
        String ref = json.path("ref").asText();
        String label = json.path("label").asText();
        boolean masterRef = json.path("isMasterRef").asBoolean();
        return new Ref(id, ref, label, masterRef, null);
    }
}

