package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by Ahmad Shami on 3/25/15.
 */
class InternalCache {
    private final static String TAG = InternalCache.class.getSimpleName();
    private final static String FILENAME = "settings";

    private final static String KEY_CONFIG_HASH = "config_hash";

    private static InternalCache instance;

    public static void init(Context context){
        if(instance == null)
            instance = new InternalCache(context);
    }

    private SharedPreferences mPrefs;
    private SharedPreferences.Editor mEditor;

    public static void setConfigHash(String configHash){
        instance.mEditor.putString(KEY_CONFIG_HASH, configHash);
        instance.mEditor.commit();
    }

    public static String getConfigFingerprint(){
        return instance.mPrefs.getString(KEY_CONFIG_HASH, null);
    }

    public static void clearAll(){
        instance.mEditor.clear();
        instance.mEditor.commit();
    }

    private InternalCache(Context context){
        this.mPrefs = context.getSharedPreferences(FILENAME, Context.MODE_PRIVATE);
        this.mEditor = mPrefs.edit();
    }
}