package io.proxsee.sdk.network.library;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;

import java.util.HashMap;

import io.realm.internal.RealmJson;

/**
 * Created by Ahmad Shami on 3/25/15.
 */
public abstract class BaseRequest<T> implements JsonConverter<T> {
    private ResponseListener<T> mResponseListener;
    private Response.ErrorListener mErrorListener;
    private BaseServerAPI mBaseServerApi;

    protected BaseRequest(BaseServerAPI serverAPI){
        this.mBaseServerApi = serverAPI;
    }

    protected RealmJson getRealmJson(){
        return mBaseServerApi.getNetworkManager().getRealmJson();
    }
    protected String getBaseUrl(){
        return mBaseServerApi.getNetworkManager().getBaseUrl();
    }
    protected Context getContext(){
        return mBaseServerApi.getNetworkManager().getContext();
    }

    public abstract Request build();

    public ResponseListener<T> getResponseListener() {
        return mResponseListener;
    }

    public void setResponseListener(ResponseListener<T> mResponseListener) {
        this.mResponseListener = mResponseListener;
    }

    public Response.ErrorListener getErrorListener() {
        return mErrorListener;
    }

    public void setErrorListener(Response.ErrorListener mErrorListener) {
        this.mErrorListener = mErrorListener;
    }

    public void sendRequest(){
        mBaseServerApi.getNetworkManager().sendRequest(this);
    }

    protected HashMap<String, String> getDefaultHeaders(){
        return mBaseServerApi.getHeaders();
    }
}
