package io.proxsee.sdk.network.library;

import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;

import org.json.JSONException;

import java.io.UnsupportedEncodingException;

/**
 * Created by Ahmad Shami on 4/29/15.
 */
public class JsonResponseHandler<T> {

    private JsonConverter<T> mJsonConverter;
    private ResponseListener<T> mResponseListener;

    public JsonResponseHandler(JsonConverter<T> jsonConverter, ResponseListener<T> listener){
        this.mJsonConverter = jsonConverter;
        this.mResponseListener = listener;
    }

    public Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        try {
            if (response.data == null || response.data.length == 0) {
                byte[] responseData = "{}".getBytes("UTF8");
                response = new NetworkResponse(response.statusCode, responseData, response.headers, response.notModified);
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return Response.success(response, HttpHeaderParser.parseCacheHeaders(response));
    }

    public void deliverResponse(NetworkResponse response) {
        String jsonString = toJsonString(response.data, HttpHeaderParser.parseCharset(response.headers));

        try {
            T model = mJsonConverter.convert(jsonString);
            mResponseListener.onResponse(response.statusCode, model);
        } catch (JSONException e) {
            e.printStackTrace();
            Response.error(new VolleyError(e));
        }
    }

    private String toJsonString(byte[] data, String charset){
        try {
            return new String(data, charset);
        } catch (UnsupportedEncodingException e) {
            return new String(data);
        }
    }
}
