package io.proxsee.sdk.network.library;

import android.content.Context;
import android.util.Log;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;

import io.proxsee.sdk.Database;
import io.realm.Realm;
import io.realm.internal.RealmJson;

/**
 * Created by Ahmad Shami on 4/28/15.
 */
public class NetworkManager {
    private final static String TAG = NetworkManager.class.getSimpleName();
    private Context mContext;
    private RequestQueue mRequestQueue;
    private Realm mRealm;
    private RealmJson mRealmJson;
    private String mBaseUrl;

    public NetworkManager(Context context, String baseUrl){
        this.mContext = context;
        this.mRequestQueue = Volley.newRequestQueue(context);
        this.mRealm = Database.getRealm(context);
        this.mRealmJson = mRealm.getRealmJson();
        this.mBaseUrl = baseUrl;
    }

    public void cancelAllRequests(){
        mRequestQueue.cancelAll(new RequestQueue.RequestFilter() {
            @Override
            public boolean apply(Request<?> request) {
                return true;
            }
        });
    }

    public void close(){
        cancelAllRequests();
        mRealm.close();
    }

    public String getBaseUrl(){
        return mBaseUrl;
    }

    Context getContext() {
        return mContext;
    }

    RequestQueue getRequestQueue() {
        return mRequestQueue;
    }

    RealmJson getRealmJson() {
        return mRealmJson;
    }

    void sendRequest(final BaseRequest<?> request){
        Request<?> r = request.build();

        getRequestQueue().cancelAll(r.getTag());
        getRequestQueue().add(r);
        Log.d(TAG, "Request Sent: " + request.getClass().getSimpleName());
    }

}
