package io.proxsee.sdk.network.library.requests;

import com.android.volley.NetworkResponse;
import com.android.volley.Response;

import org.json.JSONObject;

import io.proxsee.sdk.network.library.JsonConverter;
import io.proxsee.sdk.network.library.JsonResponseHandler;
import io.proxsee.sdk.network.library.ResponseListener;

/**
 * Created by Ahmad Shami on 3/25/15.
 */
public class JsonRequest<T> extends com.android.volley.toolbox.JsonRequest<NetworkResponse> {
    private JsonResponseHandler<T> mResponseHandler;

    public JsonRequest(int method, String url, JSONObject jsonRequest, JsonConverter<T> jsonConverter, ResponseListener<T> listener, Response.ErrorListener errorListener) {
        this(method, url, jsonRequest == null ? null : jsonRequest.toString(), jsonConverter, listener, errorListener);
    }

    public JsonRequest(int method, String url, String jsonRequest, JsonConverter<T> jsonConverter, ResponseListener<T> listener, Response.ErrorListener errorListener) {
        super(method, url, jsonRequest, null, errorListener);

        this.mResponseHandler = new JsonResponseHandler<T>(jsonConverter, listener);
    }

    public JsonRequest(int method, String url, JsonConverter<T> jsonConverter, ResponseListener<T> listener, Response.ErrorListener errorListener) {
        this(method, url, (String)null, jsonConverter, listener, errorListener);
    }

    @Override
    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        return mResponseHandler.parseNetworkResponse(response);
    }

    @Override
    protected void deliverResponse(NetworkResponse response) {
        mResponseHandler.deliverResponse(response);
    }
}
