package io.proxsee.sdk.network.library.requests;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;

import io.proxsee.sdk.network.library.JsonConverter;
import io.proxsee.sdk.network.library.JsonResponseHandler;
import io.proxsee.sdk.network.library.ResponseListener;

public class UrlEncodedRequest<T> extends Request<NetworkResponse> {
    private JsonResponseHandler<T> mResponseHandler;

    public UrlEncodedRequest(int method, String url, JsonConverter<T> jsonConverter, ResponseListener listener, com.android.volley.Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mResponseHandler = new JsonResponseHandler<T>(jsonConverter, listener);
    }

    @Override
    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        return mResponseHandler.parseNetworkResponse(response);
    }

    @Override
    protected void deliverResponse(NetworkResponse response) {
        mResponseHandler.deliverResponse(response);
    }
}