package io.proxsee.sdk.model;

import io.realm.RealmObject;

/**
 * Created by Ahmad Shami on 5/8/15.
 */
public class Beacon {
    private final int minor;
    private final int major;
    private long lastSeen;

    public Beacon(int major, int minor, long lastSeen) {
        this.major = major;
        this.minor = minor;
        this.lastSeen = lastSeen;
    }

    public int getMinor() {
        return minor;
    }

    public int getMajor() {
        return major;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Beacon)) return false;

        Beacon beacon = (Beacon) o;

        if (major != beacon.major) return false;
        if (minor != beacon.minor) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = minor;
        result = 31 * result + major;
        return result;
    }

    @Override
    public String toString() {
        return "Beacon{" +
                "major=" + major +
                ", minor=" + minor +
                '}';
    }

    public long getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

}
