package io.proxsee.sdk.network.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.JsonRequest;

/**
 * Created by Ahmad Shami on 4/10/15.
 */
public class UpdateMetadataRequest extends BaseRequest<Void> {
    private static String PATH = "/api/device/%s/metadata";
    private HashMap<String,Object> mMetadata;
    private String mUuid;

    public UpdateMetadataRequest(BaseServerAPI serverAPI, HashMap<String,Object> metadata, String uuid) {
        super(serverAPI);
        this.mMetadata = metadata;
        this.mUuid = uuid;
    }

    @Override
    public Request build() {

        JSONObject json = new JSONObject();

        try {
            json.put("metadata", new JSONObject(mMetadata));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonRequest request = new JsonRequest(Request.Method.PUT, getBaseUrl() + String.format(PATH, mUuid), json, this, getResponseListener(), getErrorListener()) {
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return getDefaultHeaders();
            }
        };
        request.setTag(this);
        return request;
    }

    @Override
    public Void convert(String json) throws JSONException {
        return null;
    }
}