/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=5)
public class BluetoothCrashResolver {
    private static final String TAG = "BluetoothCrashResolver";
    private static final boolean PREEMPTIVE_ACTION_ENABLED = true;
    private static final String DISTINCT_BLUETOOTH_ADDRESSES_FILE = "BluetoothCrashResolverState.txt";
    private boolean recoveryInProgress = false;
    private boolean discoveryStartConfirmed = false;
    private long lastBluetoothOffTime = 0L;
    private long lastBluetoothTurningOnTime = 0L;
    private long lastBluetoothCrashDetectionTime = 0L;
    private int detectedCrashCount = 0;
    private int recoveryAttemptCount = 0;
    private boolean lastRecoverySucceeded = false;
    private long lastStateSaveTime = 0L;
    private static final long MIN_TIME_BETWEEN_STATE_SAVES_MILLIS = 60000L;
    private Context context = null;
    private UpdateNotifier updateNotifier;
    private final Set<String> distinctBluetoothAddresses = new HashSet<String>();
    private static final long SUSPICIOUSLY_SHORT_BLUETOOTH_OFF_INTERVAL_MILLIS = 600L;
    private static final int BLUEDROID_MAX_BLUETOOTH_MAC_COUNT = 1990;
    private static final int BLUEDROID_POST_DISCOVERY_ESTIMATED_BLUETOOTH_MAC_COUNT = 400;
    private static final int TIME_TO_LET_DISCOVERY_RUN_MILLIS = 5000;
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                if (BluetoothCrashResolver.this.recoveryInProgress) {
                    LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth discovery finished", new Object[0]);
                    BluetoothCrashResolver.this.finishRecovery();
                } else {
                    LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth discovery finished (external)", new Object[0]);
                }
            }
            if (action.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                if (BluetoothCrashResolver.this.recoveryInProgress) {
                    BluetoothCrashResolver.this.discoveryStartConfirmed = true;
                    LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth discovery started", new Object[0]);
                } else {
                    LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth discovery started (external)", new Object[0]);
                }
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                switch (state) {
                    case -2147483648: {
                        LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth state is ERROR", new Object[0]);
                        break;
                    }
                    case 10: {
                        LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth state is OFF", new Object[0]);
                        BluetoothCrashResolver.this.lastBluetoothOffTime = System.currentTimeMillis();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 12: {
                        LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth state is ON", new Object[0]);
                        LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth was turned off for %s milliseconds", BluetoothCrashResolver.this.lastBluetoothTurningOnTime - BluetoothCrashResolver.this.lastBluetoothOffTime);
                        if (BluetoothCrashResolver.this.lastBluetoothTurningOnTime - BluetoothCrashResolver.this.lastBluetoothOffTime >= 600L) break;
                        BluetoothCrashResolver.this.crashDetected();
                        break;
                    }
                    case 11: {
                        BluetoothCrashResolver.this.lastBluetoothTurningOnTime = new Date().getTime();
                        LogManager.d(BluetoothCrashResolver.TAG, "Bluetooth state is TURNING_ON", new Object[0]);
                    }
                }
            }
        }
    };

    public BluetoothCrashResolver(Context context) {
        this.context = context.getApplicationContext();
        LogManager.d(TAG, "constructed", new Object[0]);
        this.loadState();
    }

    public void start() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        this.context.registerReceiver(this.receiver, filter);
        LogManager.d(TAG, "started listening for BluetoothAdapter events", new Object[0]);
    }

    public void stop() {
        this.context.unregisterReceiver(this.receiver);
        LogManager.d(TAG, "stopped listening for BluetoothAdapter events", new Object[0]);
        this.saveState();
    }

    @Deprecated
    public void enableDebug() {
    }

    @Deprecated
    public void disableDebug() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void notifyScannedDevice(BluetoothDevice device, BluetoothAdapter.LeScanCallback scanner) {
        int oldSize = this.distinctBluetoothAddresses.size();
        Set<String> set = this.distinctBluetoothAddresses;
        synchronized (set) {
            this.distinctBluetoothAddresses.add(device.getAddress());
        }
        int newSize = this.distinctBluetoothAddresses.size();
        if (oldSize != newSize && newSize % 100 == 0) {
            LogManager.d(TAG, "Distinct Bluetooth devices seen: %s", this.distinctBluetoothAddresses.size());
        }
        if (this.distinctBluetoothAddresses.size() > this.getCrashRiskDeviceCount() && !this.recoveryInProgress) {
            LogManager.w(TAG, "Large number of Bluetooth devices detected: %s Proactively attempting to clear out address list to prevent a crash", this.distinctBluetoothAddresses.size());
            LogManager.w(TAG, "Stopping LE Scan", new Object[0]);
            BluetoothAdapter.getDefaultAdapter().stopLeScan(scanner);
            this.startRecovery();
            this.processStateChange();
        }
    }

    public void crashDetected() {
        long nowTimestamp;
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.d(TAG, "Ignoring crashes before API 18, because BLE is unsupported.", new Object[0]);
            return;
        }
        LogManager.w(TAG, "BluetoothService crash detected", new Object[0]);
        if (this.distinctBluetoothAddresses.size() > 0) {
            LogManager.d(TAG, "Distinct Bluetooth devices seen at crash: %s", this.distinctBluetoothAddresses.size());
        }
        this.lastBluetoothCrashDetectionTime = nowTimestamp = new Date().getTime();
        ++this.detectedCrashCount;
        if (this.recoveryInProgress) {
            LogManager.d(TAG, "Ignoring Bluetooth crash because recovery is already in progress.", new Object[0]);
        } else {
            this.startRecovery();
        }
        this.processStateChange();
    }

    public long getLastBluetoothCrashDetectionTime() {
        return this.lastBluetoothCrashDetectionTime;
    }

    public int getDetectedCrashCount() {
        return this.detectedCrashCount;
    }

    public int getRecoveryAttemptCount() {
        return this.recoveryAttemptCount;
    }

    public boolean isLastRecoverySucceeded() {
        return this.lastRecoverySucceeded;
    }

    public boolean isRecoveryInProgress() {
        return this.recoveryInProgress;
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.updateNotifier = updateNotifier;
    }

    public void forceFlush() {
        this.startRecovery();
        this.processStateChange();
    }

    private int getCrashRiskDeviceCount() {
        return 1590;
    }

    private void processStateChange() {
        if (this.updateNotifier != null) {
            this.updateNotifier.dataUpdated();
        }
        if (System.currentTimeMillis() - this.lastStateSaveTime > 60000L) {
            this.saveState();
        }
    }

    @TargetApi(value=17)
    private void startRecovery() {
        ++this.recoveryAttemptCount;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        LogManager.d(TAG, "about to check if discovery is active", new Object[0]);
        if (!adapter.isDiscovering()) {
            LogManager.w(TAG, "Recovery attempt started", new Object[0]);
            this.recoveryInProgress = true;
            this.discoveryStartConfirmed = false;
            LogManager.d(TAG, "about to command discovery", new Object[0]);
            if (!adapter.startDiscovery()) {
                LogManager.w(TAG, "Can't start discovery.  Is Bluetooth turned on?", new Object[0]);
            }
            LogManager.d(TAG, "startDiscovery commanded.  isDiscovering()=%s", adapter.isDiscovering());
            LogManager.d(TAG, "We will be cancelling this discovery in %s milliseconds.", 5000);
            this.cancelDiscovery();
        } else {
            LogManager.w(TAG, "Already discovering.  Recovery attempt abandoned.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRecovery() {
        LogManager.w(TAG, "Recovery attempt finished", new Object[0]);
        Set<String> set = this.distinctBluetoothAddresses;
        synchronized (set) {
            this.distinctBluetoothAddresses.clear();
        }
        this.recoveryInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState() {
        OutputStreamWriter writer = null;
        this.lastStateSaveTime = new Date().getTime();
        try {
            FileOutputStream outputStream = this.context.openFileOutput(DISTINCT_BLUETOOTH_ADDRESSES_FILE, 0);
            writer = new OutputStreamWriter(outputStream);
            writer.write(this.lastBluetoothCrashDetectionTime + "\n");
            writer.write(this.detectedCrashCount + "\n");
            writer.write(this.recoveryAttemptCount + "\n");
            writer.write(this.lastRecoverySucceeded ? "1\n" : "0\n");
            Set<String> set = this.distinctBluetoothAddresses;
            synchronized (set) {
                for (String mac : this.distinctBluetoothAddresses) {
                    writer.write(mac);
                    writer.write("\n");
                }
            }
        }
        catch (IOException e) {
            LogManager.w(TAG, "Can't write macs to %s", DISTINCT_BLUETOOTH_ADDRESSES_FILE);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        LogManager.d(TAG, "Wrote %s Bluetooth addresses", this.distinctBluetoothAddresses.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState() {
        BufferedReader reader = null;
        try {
            String mac;
            FileInputStream inputStream = this.context.openFileInput(DISTINCT_BLUETOOTH_ADDRESSES_FILE);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            if (line != null) {
                this.lastBluetoothCrashDetectionTime = Long.parseLong(line);
            }
            if ((line = reader.readLine()) != null) {
                this.detectedCrashCount = Integer.parseInt(line);
            }
            if ((line = reader.readLine()) != null) {
                this.recoveryAttemptCount = Integer.parseInt(line);
            }
            if ((line = reader.readLine()) != null) {
                this.lastRecoverySucceeded = false;
                if (line.equals("1")) {
                    this.lastRecoverySucceeded = true;
                }
            }
            while ((mac = reader.readLine()) != null) {
                this.distinctBluetoothAddresses.add(mac);
            }
        }
        catch (IOException e) {
            LogManager.w(TAG, "Can't read macs from %s", DISTINCT_BLUETOOTH_ADDRESSES_FILE);
        }
        catch (NumberFormatException e) {
            LogManager.w(TAG, "Can't parse file %s", DISTINCT_BLUETOOTH_ADDRESSES_FILE);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {}
            }
        }
        LogManager.d(TAG, "Read %s Bluetooth addresses", this.distinctBluetoothAddresses.size());
    }

    private void cancelDiscovery() {
        try {
            BluetoothAdapter adapter;
            Thread.sleep(5000L);
            if (!this.discoveryStartConfirmed) {
                LogManager.w(TAG, "BluetoothAdapter.ACTION_DISCOVERY_STARTED never received.  Recovery may fail.", new Object[0]);
            }
            if ((adapter = BluetoothAdapter.getDefaultAdapter()).isDiscovering()) {
                LogManager.d(TAG, "Cancelling discovery", new Object[0]);
                adapter.cancelDiscovery();
            } else {
                LogManager.d(TAG, "Discovery not running.  Won't cancel it", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            LogManager.d(TAG, "DiscoveryCanceller sleep interrupted.", new Object[0]);
        }
    }

    public static interface UpdateNotifier {
        public void dataUpdated();
    }
}

