package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.model.CachedBeacon;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CachedBeaconRealmProxy extends CachedBeacon {

    @Override
    public int getMinor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("CachedBeacon").get("minor"));
    }

    @Override
    public void setMinor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("CachedBeacon").get("minor"), (long) value);
    }

    @Override
    public int getMajor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("CachedBeacon").get("major"));
    }

    @Override
    public void setMajor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("CachedBeacon").get("major"), (long) value);
    }

    @Override
    public long getLastSeenTime() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("CachedBeacon").get("lastSeenTime"));
    }

    @Override
    public void setLastSeenTime(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("CachedBeacon").get("lastSeenTime"), (long) value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if(!transaction.hasTable("class_CachedBeacon")) {
            Table table = transaction.getTable("class_CachedBeacon");
            table.addColumn(ColumnType.INTEGER, "minor");
            table.addColumn(ColumnType.INTEGER, "major");
            table.addColumn(ColumnType.INTEGER, "lastSeenTime");
            table.setPrimaryKey("");
            return table;
        }
        return transaction.getTable("class_CachedBeacon");
    }

    public static void validateTable(ImplicitTransaction transaction) {
        if(transaction.hasTable("class_CachedBeacon")) {
            Table table = transaction.getTable("class_CachedBeacon");
            if(table.getColumnCount() != 3) {
                throw new IllegalStateException("Column count does not match");
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for(long i = 0; i < 3; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            if (!columnTypes.containsKey("minor")) {
                throw new IllegalStateException("Missing column 'minor'");
            }
            if (columnTypes.get("minor") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'minor'");
            }
            if (!columnTypes.containsKey("major")) {
                throw new IllegalStateException("Missing column 'major'");
            }
            if (columnTypes.get("major") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'major'");
            }
            if (!columnTypes.containsKey("lastSeenTime")) {
                throw new IllegalStateException("Missing column 'lastSeenTime'");
            }
            if (columnTypes.get("lastSeenTime") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'lastSeenTime'");
            }
        }
    }

    public static List<String> getFieldNames() {
        return Arrays.asList("minor", "major", "lastSeenTime");
    }

    public static void populateUsingJsonObject(CachedBeacon obj, JSONObject json)
        throws JSONException {
        boolean standalone = obj.realm == null;
        if (!json.isNull("minor")) {
            obj.setMinor((int) json.getInt("minor"));
        }
        if (!json.isNull("major")) {
            obj.setMajor((int) json.getInt("major"));
        }
        if (!json.isNull("lastSeenTime")) {
            obj.setLastSeenTime((long) json.getLong("lastSeenTime"));
        }
    }

    public static void populateUsingJsonStream(CachedBeacon obj, JsonReader reader)
        throws IOException {
        boolean standalone = obj.realm == null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("minor") && reader.peek() != JsonToken.NULL) {
                obj.setMinor((int) reader.nextInt());
            } else if (name.equals("major")  && reader.peek() != JsonToken.NULL) {
                obj.setMajor((int) reader.nextInt());
            } else if (name.equals("lastSeenTime")  && reader.peek() != JsonToken.NULL) {
                obj.setLastSeenTime((long) reader.nextLong());
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
    }

    public static CachedBeacon copyOrUpdate(Realm realm, CachedBeacon object, boolean update, Map<RealmObject,RealmObject> cache) {
        return copy(realm, object, update, cache);
    }

    public static CachedBeacon copy(Realm realm, CachedBeacon newObject, boolean update, Map<RealmObject,RealmObject> cache) {
        CachedBeacon realmObject = realm.createObject(CachedBeacon.class);
        cache.put(newObject, realmObject);
        realmObject.setMinor(newObject.getMinor());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setLastSeenTime(newObject.getLastSeenTime());
        return realmObject;
    }

    static CachedBeacon update(Realm realm, CachedBeacon realmObject, CachedBeacon newObject, Map<RealmObject, RealmObject> cache) {
        realmObject.setMinor(newObject.getMinor());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setLastSeenTime(newObject.getLastSeenTime());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("CachedBeacon = [");
        stringBuilder.append("{minor:");
        stringBuilder.append(getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lastSeenTime:");
        stringBuilder.append(getLastSeenTime());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CachedBeaconRealmProxy aCachedBeacon = (CachedBeaconRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aCachedBeacon.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aCachedBeacon.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aCachedBeacon.row.getIndex()) return false;

        return true;
    }

}
