/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import org.altbeacon.beacon.logging.LogManager;

public class Callback {
    private static final String TAG = "Callback";
    private Intent intent;

    public Callback(String intentPackageName) {
        if (intentPackageName != null) {
            this.intent = new Intent();
            this.intent.setComponent(new ComponentName(intentPackageName, "org.altbeacon.beacon.BeaconIntentProcessor"));
        }
    }

    public Intent getIntent() {
        return this.intent;
    }

    public void setIntent(Intent intent) {
        this.intent = intent;
    }

    public boolean call(Context context, String dataName, Parcelable data) {
        if (this.intent != null) {
            LogManager.d(TAG, "attempting callback via intent: %s", this.intent.getComponent());
            this.intent.putExtra(dataName, data);
            context.startService(this.intent);
            return true;
        }
        return false;
    }
}

