package io.proxsee.sdk;

import android.content.Context;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import io.realm.Realm;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.exceptions.RealmMigrationNeededException;

/**
 * Created by Ahmad Shami on 3/27/15.
 */
public class Database {
    private final static String TAG = Database.class.getSimpleName();

    public static Database open(Context context){
        return new Database(context);
    }

    private Realm mRealm;

    private Database(Context context){
        this.mRealm = getRealm(context);
    }

    public void close(){
        mRealm.close();
    }


    public <E extends RealmObject> List<E> getAll(Class<E> clazz){
        return mRealm.where(clazz).findAll();
    }

    public <E extends RealmObject> void add(Iterable<E> entries){
        mRealm.beginTransaction();
        mRealm.copyToRealm(entries);
        mRealm.commitTransaction();
    }

    public <E extends RealmObject> void add(E... entries){
        add(Arrays.asList(entries));
    }

    public <E extends RealmObject> void set(Class<E> clazz, Iterable<E> entries){
        mRealm.beginTransaction();
        mRealm.where(clazz).findAll().clear();
        mRealm.copyToRealm(entries);
        mRealm.commitTransaction();
    }

    public <E extends RealmObject> void set(Class<E> clazz, E... entries){
        this.set(clazz, Arrays.asList(entries));
    }

    public <E extends RealmObject> void clear(Class<E> clazz){
        mRealm.beginTransaction();
        mRealm.where(clazz).findAll().clear();
        mRealm.commitTransaction();
    }

    public static Realm getRealm(Context context) {
        Realm realm = null;
        try {
            realm = Realm.getInstance(context);
        } catch (RealmMigrationNeededException e) {
            Realm.migrateRealmAtPath(new File(context.getFilesDir(), "default.realm").getPath(), new ProxSeeDBMigration(context));
            realm = Realm.getInstance(context);
        }
        return realm;
    }

    private static class ProxSeeDBMigration implements RealmMigration {

        private Context context;

        ProxSeeDBMigration(Context context) {
            this.context = context;
        }

        @Override
        public long execute(Realm realm, long version) {
            Realm.deleteRealmFile(context);
            return version;
        }

    }

}
