package io.proxsee.sdk.network.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import io.proxsee.sdk.model.TaggedBeacon;
import io.proxsee.sdk.network.ServerAPI;
import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.UrlEncodedRequest;

/**
 * Created by Ahmad Shami on 4/10/15.
 */
public class AroundBeaconsRequest extends BaseRequest<TaggedBeacon[]> {
    private final static String TAG = AroundBeaconsRequest.class.getSimpleName();
    private static String PATH = "/api/beacon/arround/%s/%s/tags";

    private int mMajor;
    private int mMinor;
    private int mRadius;

    public AroundBeaconsRequest(BaseServerAPI serverAPI, int major, int minor, int radius){
        super(serverAPI);
        this.mMajor = major;
        this.mMinor = minor;
        this.mRadius = radius;
    }


    @Override
    public Request build() {
        String requestTag = this+"-" + mMajor + "-" + mMinor;

        UrlEncodedRequest request = new UrlEncodedRequest(Request.Method.GET, getBaseUrl() + String.format(PATH, mMajor, mMinor), this, getResponseListener(), getErrorListener()){
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String,String> headers = getDefaultHeaders();
                headers.put("Content-Type", ServerAPI.ContentType.URL_ENCODED.getTag());
                return headers;
            }

            @Override
            protected Map<String, String> getParams() throws AuthFailureError {
                Map<String, String> params = new HashMap<String, String>();
                params.put("radius", "" + mRadius);
                return params;
            }
        };

        request.setTag(requestTag);

        return request;
    }

    @Override
    public TaggedBeacon[] convert(String json) throws JSONException {
        JSONArray jsonArray = new JSONArray(json);
        TaggedBeacon[] beacons = new TaggedBeacon[jsonArray.length()];
        for (int x = 0; x < jsonArray.length(); x++) {
            JSONObject jsonBeacon = jsonArray.getJSONObject(x);
            TaggedBeacon beacon = new TaggedBeacon();
            beacon.setMajor(jsonBeacon.getInt("major"));
            beacon.setMinor(jsonBeacon.getInt("minor"));
            beacon.setName(jsonBeacon.getString("name"));
            beacon.setDistance(jsonBeacon.getInt("distance"));

            JSONArray jsonTags = jsonBeacon.getJSONArray("tags");
            String[] tags = new String[jsonTags.length()];
            for (int y = 0; y < jsonTags.length(); y++) {
                tags[y] = jsonTags.getString(y);
            }
            beacon.setTags(tags);

            beacons[x] = beacon;
        }

        return beacons;
    }
}
