/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.distance;

import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;

public class CurveFittedDistanceCalculator
implements DistanceCalculator {
    public static final String TAG = "CurveFittedDistanceCalculator";
    private double mCoefficient1;
    private double mCoefficient2;
    private double mCoefficient3;

    public CurveFittedDistanceCalculator(double coefficient1, double coefficient2, double coefficient3) {
        this.mCoefficient1 = coefficient1;
        this.mCoefficient2 = coefficient2;
        this.mCoefficient3 = coefficient3;
    }

    @Override
    public double calculateDistance(int txPower, double rssi) {
        if (rssi == 0.0) {
            return -1.0;
        }
        LogManager.d(TAG, "calculating distance based on mRssi of %s and txPower of %s", rssi, txPower);
        double ratio = rssi * 1.0 / (double)txPower;
        double distance = ratio < 1.0 ? Math.pow(ratio, 10.0) : this.mCoefficient1 * Math.pow(ratio, this.mCoefficient2) + this.mCoefficient3;
        LogManager.d(TAG, "avg mRssi: %s distance: %s", rssi, distance);
        return distance;
    }
}

