package io.proxsee.sdk.misc;

import java.util.Comparator;

import io.proxsee.sdk.model.Beacon;

/**
 * Sorts beacons on the basis of the major/minor
 */
public class BeaconMajorMinorComparator implements Comparator<Beacon> {
    @Override
    public int compare(Beacon beacon, Beacon t1) {
        if (beacon.getMajor() < t1.getMajor()) {
            return -1;
        }

        if (beacon.getMajor() == t1.getMajor()) {
            if (beacon.getMinor() < t1.getMinor()) {
                return -1;
            }

            if (beacon.getMinor() == t1.getMinor()) {
                return 0;
            }
        }

        return 1;
    }
}
