package io.proxsee.sdk.model;

import io.proxsee.sdk.model.persist.PersistentBeacon;

/**
 * Created by Ahmad Shami on 5/8/15.
 */
public class Beacon extends TaggedBeacon{
    private long lastSeen;

    public Beacon(TaggedBeacon taggedBeacon, long lastSeen) {
        setMinor(taggedBeacon.getMinor());
        setMajor(taggedBeacon.getMajor());
        setDistance(taggedBeacon.getDistance());
        setLat(taggedBeacon.getLat());
        setLng(taggedBeacon.getLng());
        setGeofence(taggedBeacon.isGeofence());
        setRadius(taggedBeacon.getRadius());
        setName(taggedBeacon.getName());
        setTags(taggedBeacon.getTags());
        setLastSeen(lastSeen);
        setGeofence(taggedBeacon.isGeofence());
    }

    public Beacon(org.altbeacon.beacon.Beacon beacon, long lastSeen){
        setMajor(beacon.getId2().toInt());
        setMinor(beacon.getId3().toInt());
        setLastSeen(lastSeen);
        setGeofence(false);
    }

    public Beacon(PersistentBeacon beacon){
        setMajor(beacon.getMajor());
        setMinor(beacon.getMinor());
        setName(beacon.getName());
        setLastSeen(beacon.getLastSeenTime());
        setLng(beacon.getLongitude());
        setLat(beacon.getLatitude());
        setRadius(beacon.getRadius());
        setGeofence(beacon.isVirtual());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Beacon)) return false;

        Beacon beacon = (Beacon) o;

        if (getMajor() != beacon.getMajor()) return false;
        if (getMinor() != beacon.getMinor()) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = getMinor();
        result = 31 * result + getMajor();
        return result;
    }

    public long getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }
}
