package io.proxsee.sdk.model.persist;

import io.proxsee.sdk.model.Beacon;
import io.proxsee.sdk.model.TaggedBeacon;
import io.realm.RealmObject;
import io.realm.annotations.RealmClass;

/**
 * Created by Ahmad Shami on 5/8/15.
 *
 * Note that classes extending RealObject can only define setters and getters,
 * Thus we had to create Beacon class separately to override the .equals(), .hashCode() and .toString()
 */
@RealmClass
public class PersistentBeacon extends RealmObject{
    private String name;
    private int minor;
    private int major;
    private long lastSeenTime;
    private double latitude;
    private double longitude;
    private float radius;
    private boolean virtual;

    public PersistentBeacon(){

    }

    public PersistentBeacon(TaggedBeacon taggedBeacon){
        setName(taggedBeacon.getName());
        setMajor(taggedBeacon.getMajor());
        setMinor(taggedBeacon.getMinor());
        setLatitude(taggedBeacon.getLat());
        setLongitude(taggedBeacon.getLng());
        setRadius(taggedBeacon.getRadius());
        setVirtual(taggedBeacon.isGeofence());
    }

    public PersistentBeacon(Beacon beacon){
        this((TaggedBeacon) beacon);
        setLastSeenTime(beacon.getLastSeen());
    }

    public int getMinor() {
        return minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMajor() {
        return major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public long getLastSeenTime() {
        return lastSeenTime;
    }

    public void setLastSeenTime(long lastSeenTime) {
        this.lastSeenTime = lastSeenTime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public float getRadius() {
        return radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean isVirtual() {
        return virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }
}
