package io.proxsee.sdk.network;

import android.content.Context;

import com.android.volley.Response;

import java.util.HashMap;

import io.proxsee.sdk.BuildConfig;
import io.proxsee.sdk.model.Beacon;
import io.proxsee.sdk.model.persist.MonitoringRegion;
import io.proxsee.sdk.model.TaggedBeacon;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.ResponseListener;
import io.proxsee.sdk.network.requests.AroundBeaconsRequest;
import io.proxsee.sdk.network.requests.CheckInRequest;
import io.proxsee.sdk.network.requests.CheckOutRequest;
import io.proxsee.sdk.network.requests.MonitoringRegionsRequest;
import io.proxsee.sdk.network.requests.UpdateMetadataRequest;

/**
 * Created by Ahmad Shami on 3/25/15.
 */
public class ServerAPI extends BaseServerAPI{
    protected static final String X_ProxSee_SDKPlatform = "X-ProxSee-SDKPlatform";
    protected static final String X_ProxSee_SDKVersion = "X-ProxSee-SDKVersion";
    protected static final String PLATFORM_ANDROID = "android";

    private String mApiKey;

    public ServerAPI(Context context, String apiKey, String baseUrl){
        super(context, baseUrl);
        this.mApiKey = apiKey;
    }

    public void fetchRegions(ResponseListener<MonitoringRegion[]> responseListener, Response.ErrorListener errorListener){
        MonitoringRegionsRequest request = new MonitoringRegionsRequest(this);
        request.setResponseListener(responseListener);
        request.setErrorListener(errorListener);
        request.sendRequest();
    }

    public void checkIn(Beacon beacon, String uuid, ResponseListener<Void> responseListener, Response.ErrorListener errorListener){
        CheckInRequest request = new CheckInRequest(this, beacon, uuid);
        request.setResponseListener(responseListener);
        request.setErrorListener(errorListener);
        request.sendRequest();
    }

    public void checkOut(Beacon beacon, String uuid, boolean impliedCheckout, ResponseListener<Void> responseListener, Response.ErrorListener errorListener){
        CheckOutRequest request = new CheckOutRequest(this, beacon, uuid, impliedCheckout);
        request.setResponseListener(responseListener);
        request.setErrorListener(errorListener);
        request.sendRequest();
    }

    public void setMetadata(HashMap<String, Object> metadata, String uuid, ResponseListener<Void> responseListener, Response.ErrorListener errorListener){
        UpdateMetadataRequest request = new UpdateMetadataRequest(this, metadata, uuid);
        request.setResponseListener(responseListener);
        request.setErrorListener(errorListener);
        request.sendRequest();
    }

    public void getBeaconsAround(int major, int minor, int radius, ResponseListener<TaggedBeacon[]> responseListener, Response.ErrorListener errorListener){
        AroundBeaconsRequest request = new AroundBeaconsRequest(this, major, minor, radius);
        request.setResponseListener(responseListener);
        request.setErrorListener(errorListener);
        request.sendRequest();
    }

    @Override
    public HashMap<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + mApiKey);
        headers.put("Content-Type", ContentType.JSON.getTag());
        headers.put("Accept", ContentType.JSON.getTag());
        headers.put("Accept-Encoding", "UTF-8");
        headers.put(X_ProxSee_SDKPlatform, PLATFORM_ANDROID);
        headers.put(X_ProxSee_SDKVersion, BuildConfig.CONCATINATED_VERSION_NAME);
        return headers;
    }

    public enum ContentType{
        JSON("application/json"),
        URL_ENCODED("application/x-www-form-urlencoded");

        private String tag;
        private ContentType(String tag){
            this.tag = tag;
        }

        public String getTag(){
            return tag;
        }
    }
}
