package io.proxsee.sdk.network.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.google.gson.Gson;

import org.json.JSONException;

import java.util.HashMap;
import java.util.Map;

import io.proxsee.sdk.model.TaggedBeacon;
import io.proxsee.sdk.network.ServerAPI;
import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.UrlEncodedRequest;

/**
 * Created by Ahmad Shami on 4/10/15.
 */
public class AroundBeaconsRequest extends BaseRequest<TaggedBeacon[]> {
    private final static String TAG = AroundBeaconsRequest.class.getSimpleName();
    private static String PATH = "/api/beacon/around/%s/%s/tags";

    private int mMajor;
    private int mMinor;
    private int mRadius;

    public AroundBeaconsRequest(BaseServerAPI serverAPI, int major, int minor, int radius){
        super(serverAPI);
        this.mMajor = major;
        this.mMinor = minor;
        this.mRadius = radius;
    }


    @Override
    public Request build() {
        String requestTag = this+"-" + mMajor + "-" + mMinor;

        UrlEncodedRequest request = new UrlEncodedRequest(Request.Method.GET, getBaseUrl() + String.format(PATH, mMajor, mMinor), this, getResponseListener(), getErrorListener()){
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                Map<String,String> headers = getDefaultHeaders();
                headers.put("Content-Type", ServerAPI.ContentType.URL_ENCODED.getTag());
                return headers;
            }

            @Override
            protected Map<String, String> getParams() throws AuthFailureError {
                Map<String, String> params = new HashMap<String, String>();
                params.put("radius", "" + mRadius);
                return params;
            }
        };

        request.setTag(requestTag);

        return request;
    }

    @Override
    public TaggedBeacon[] convert(String json) throws JSONException {
        return new Gson().fromJson(json, TaggedBeacon[].class);
    }
}
