package io.proxsee.sdk.network.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

import io.proxsee.sdk.misc.Utils;
import io.proxsee.sdk.model.Beacon;
import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.JsonRequest;

/**
 * Created by Ahmad Shami on 4/9/15.
 */
public class CheckOutRequest extends BaseRequest<Void>{
    private static String PATH = "/api/device/%s/check-out";

    private String mUuid;
    private Beacon mBeacon;
    private boolean mImpliedCheckout = false;

    public CheckOutRequest(BaseServerAPI serverAPI, Beacon beacon, String uuid, boolean impliedCheckout){
        super(serverAPI);
        this.mBeacon = beacon;
        this.mUuid = uuid;
        this.mImpliedCheckout = impliedCheckout;
    }

    @Override
    public Request<Void> build() {
        JSONObject json = new JSONObject();
        try {
            json.put("major", mBeacon.getMajor());
            json.put("minor", mBeacon.getMinor());
            json.put("at", Utils.getUtcInMillis());
            if (mImpliedCheckout) {
                json.put("impliedCheckout", mImpliedCheckout);
            }
        }catch (JSONException e){
            e.printStackTrace();
        }

        JsonRequest request = new JsonRequest(Request.Method.POST, getBaseUrl() + String.format(PATH, mUuid), json, this, getResponseListener(), getErrorListener()){
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return getDefaultHeaders();
            }
        };

        request.setTag(this);
        return request;
    }

    @Override
    public Void convert(String json) throws JSONException {
        return null;
    }
}
