package io.proxsee.sdk.network.requests;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.Map;

import io.proxsee.sdk.model.persist.MonitoringRegion;
import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.JsonRequest;

/**
 * Created by Ahmad Shami on 3/25/15.
 */
public class MonitoringRegionsRequest extends BaseRequest<MonitoringRegion[]> {
    private static String PATH = "/api/monitoringregions";

    public MonitoringRegionsRequest(BaseServerAPI serverAPI){
        super(serverAPI);
    }

    @Override
    public Request<MonitoringRegion[]> build() {
        JsonRequest request = new JsonRequest(Request.Method.GET, getBaseUrl() + PATH, this, getResponseListener(), getErrorListener()){
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return getDefaultHeaders();
            }
        };

        request.setTag(this);
        return request;
    }

    @Override
    public MonitoringRegion[] convert(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        MonitoringRegion[] dst = new MonitoringRegion[array.length()];

        for(int i = 0; i < array.length(); i++) {
            MonitoringRegion cur = new MonitoringRegion();
            getRealmJson().populateUsingJsonObject(cur, array.getJSONObject(i));
            dst[i] = cur;
        }
        return dst;
    }
}
