package io.proxsee.sdk.network.requests;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import org.json.JSONException;

import java.util.HashMap;
import java.util.Map;

import io.proxsee.sdk.network.library.BaseRequest;
import io.proxsee.sdk.network.library.BaseServerAPI;
import io.proxsee.sdk.network.library.requests.JsonRequest;

/**
 * Created by Ahmad Shami on 4/10/15.
 */
public class UpdateMetadataRequest extends BaseRequest<Void> {
    private final static String TAG = UpdateMetadataRequest.class.getSimpleName();
    private static String PATH = "/api/device/%s/metadata";
    private HashMap<String,Object> mMetadata;
    private String mUuid;

    public UpdateMetadataRequest(BaseServerAPI serverAPI, HashMap<String,Object> metadata, String uuid) {
        super(serverAPI);
        this.mMetadata = metadata;
        this.mUuid = uuid;
    }

    @Override
    public Request build() {
        Gson gson = new Gson();
        JsonElement je = gson.toJsonTree(mMetadata);
        JsonObject jo = new JsonObject();
        jo.add("metadata", je);

        JsonRequest request = new JsonRequest(Request.Method.PUT, getBaseUrl() + String.format(PATH, mUuid), jo.toString(), this, getResponseListener(), getErrorListener()) {
            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return getDefaultHeaders();
            }
        };
        request.setTag(this);
        return request;
    }

    @Override
    public Void convert(String json) throws JSONException {
        return null;
    }
}