package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.model.persist.MonitoringRegion;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitoringRegionRealmProxy extends MonitoringRegion {

    @Override
    public String getUuid() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(Realm.columnIndices.get("MonitoringRegion").get("uuid"));
    }

    @Override
    public void setUuid(String value) {
        realm.checkIfValid();
        row.setString(Realm.columnIndices.get("MonitoringRegion").get("uuid"), (String) value);
    }

    @Override
    public int getMajor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("MonitoringRegion").get("major"));
    }

    @Override
    public void setMajor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("MonitoringRegion").get("major"), (long) value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if(!transaction.hasTable("class_MonitoringRegion")) {
            Table table = transaction.getTable("class_MonitoringRegion");
            table.addColumn(ColumnType.STRING, "uuid");
            table.addColumn(ColumnType.INTEGER, "major");
            table.setPrimaryKey("");
            return table;
        }
        return transaction.getTable("class_MonitoringRegion");
    }

    public static void validateTable(ImplicitTransaction transaction) {
        if(transaction.hasTable("class_MonitoringRegion")) {
            Table table = transaction.getTable("class_MonitoringRegion");
            if(table.getColumnCount() != 2) {
                throw new IllegalStateException("Column count does not match");
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for(long i = 0; i < 2; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            if (!columnTypes.containsKey("uuid")) {
                throw new IllegalStateException("Missing column 'uuid'");
            }
            if (columnTypes.get("uuid") != ColumnType.STRING) {
                throw new IllegalStateException("Invalid type 'String' for column 'uuid'");
            }
            if (!columnTypes.containsKey("major")) {
                throw new IllegalStateException("Missing column 'major'");
            }
            if (columnTypes.get("major") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'major'");
            }
        }
    }

    public static List<String> getFieldNames() {
        return Arrays.asList("uuid", "major");
    }

    public static void populateUsingJsonObject(MonitoringRegion obj, JSONObject json)
        throws JSONException {
        boolean standalone = obj.realm == null;
        if (!json.isNull("uuid")) {
            obj.setUuid((String) json.getString("uuid"));
        }
        if (!json.isNull("major")) {
            obj.setMajor((int) json.getInt("major"));
        }
    }

    public static void populateUsingJsonStream(MonitoringRegion obj, JsonReader reader)
        throws IOException {
        boolean standalone = obj.realm == null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("uuid") && reader.peek() != JsonToken.NULL) {
                obj.setUuid((String) reader.nextString());
            } else if (name.equals("major")  && reader.peek() != JsonToken.NULL) {
                obj.setMajor((int) reader.nextInt());
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
    }

    public static MonitoringRegion copyOrUpdate(Realm realm, MonitoringRegion object, boolean update, Map<RealmObject,RealmObject> cache) {
        return copy(realm, object, update, cache);
    }

    public static MonitoringRegion copy(Realm realm, MonitoringRegion newObject, boolean update, Map<RealmObject,RealmObject> cache) {
        MonitoringRegion realmObject = realm.createObject(MonitoringRegion.class);
        cache.put(newObject, realmObject);
        realmObject.setUuid(newObject.getUuid() != null ? newObject.getUuid() : "");
        realmObject.setMajor(newObject.getMajor());
        return realmObject;
    }

    static MonitoringRegion update(Realm realm, MonitoringRegion realmObject, MonitoringRegion newObject, Map<RealmObject, RealmObject> cache) {
        realmObject.setUuid(newObject.getUuid() != null ? newObject.getUuid() : "");
        realmObject.setMajor(newObject.getMajor());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("MonitoringRegion = [");
        stringBuilder.append("{uuid:");
        stringBuilder.append(getUuid());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(getMajor());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MonitoringRegionRealmProxy aMonitoringRegion = (MonitoringRegionRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aMonitoringRegion.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aMonitoringRegion.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aMonitoringRegion.row.getIndex()) return false;

        return true;
    }

}
