package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.model.persist.PersistentBeacon;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PersistentBeaconRealmProxy extends PersistentBeacon {

    @Override
    public String getName() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(Realm.columnIndices.get("PersistentBeacon").get("name"));
    }

    @Override
    public void setName(String value) {
        realm.checkIfValid();
        row.setString(Realm.columnIndices.get("PersistentBeacon").get("name"), (String) value);
    }

    @Override
    public int getMinor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("PersistentBeacon").get("minor"));
    }

    @Override
    public void setMinor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("PersistentBeacon").get("minor"), (long) value);
    }

    @Override
    public int getMajor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("PersistentBeacon").get("major"));
    }

    @Override
    public void setMajor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("PersistentBeacon").get("major"), (long) value);
    }

    @Override
    public long getLastSeenTime() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("PersistentBeacon").get("lastSeenTime"));
    }

    @Override
    public void setLastSeenTime(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("PersistentBeacon").get("lastSeenTime"), (long) value);
    }

    @Override
    public double getLatitude() {
        realm.checkIfValid();
        return (double) row.getDouble(Realm.columnIndices.get("PersistentBeacon").get("latitude"));
    }

    @Override
    public void setLatitude(double value) {
        realm.checkIfValid();
        row.setDouble(Realm.columnIndices.get("PersistentBeacon").get("latitude"), (double) value);
    }

    @Override
    public double getLongitude() {
        realm.checkIfValid();
        return (double) row.getDouble(Realm.columnIndices.get("PersistentBeacon").get("longitude"));
    }

    @Override
    public void setLongitude(double value) {
        realm.checkIfValid();
        row.setDouble(Realm.columnIndices.get("PersistentBeacon").get("longitude"), (double) value);
    }

    @Override
    public float getRadius() {
        realm.checkIfValid();
        return (float) row.getFloat(Realm.columnIndices.get("PersistentBeacon").get("radius"));
    }

    @Override
    public void setRadius(float value) {
        realm.checkIfValid();
        row.setFloat(Realm.columnIndices.get("PersistentBeacon").get("radius"), (float) value);
    }

    @Override
    public boolean isVirtual() {
        realm.checkIfValid();
        return (boolean) row.getBoolean(Realm.columnIndices.get("PersistentBeacon").get("virtual"));
    }

    @Override
    public void setVirtual(boolean value) {
        realm.checkIfValid();
        row.setBoolean(Realm.columnIndices.get("PersistentBeacon").get("virtual"), (boolean) value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if(!transaction.hasTable("class_PersistentBeacon")) {
            Table table = transaction.getTable("class_PersistentBeacon");
            table.addColumn(ColumnType.STRING, "name");
            table.addColumn(ColumnType.INTEGER, "minor");
            table.addColumn(ColumnType.INTEGER, "major");
            table.addColumn(ColumnType.INTEGER, "lastSeenTime");
            table.addColumn(ColumnType.DOUBLE, "latitude");
            table.addColumn(ColumnType.DOUBLE, "longitude");
            table.addColumn(ColumnType.FLOAT, "radius");
            table.addColumn(ColumnType.BOOLEAN, "virtual");
            table.setPrimaryKey("");
            return table;
        }
        return transaction.getTable("class_PersistentBeacon");
    }

    public static void validateTable(ImplicitTransaction transaction) {
        if(transaction.hasTable("class_PersistentBeacon")) {
            Table table = transaction.getTable("class_PersistentBeacon");
            if(table.getColumnCount() != 8) {
                throw new IllegalStateException("Column count does not match");
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for(long i = 0; i < 8; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            if (!columnTypes.containsKey("name")) {
                throw new IllegalStateException("Missing column 'name'");
            }
            if (columnTypes.get("name") != ColumnType.STRING) {
                throw new IllegalStateException("Invalid type 'String' for column 'name'");
            }
            if (!columnTypes.containsKey("minor")) {
                throw new IllegalStateException("Missing column 'minor'");
            }
            if (columnTypes.get("minor") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'minor'");
            }
            if (!columnTypes.containsKey("major")) {
                throw new IllegalStateException("Missing column 'major'");
            }
            if (columnTypes.get("major") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'major'");
            }
            if (!columnTypes.containsKey("lastSeenTime")) {
                throw new IllegalStateException("Missing column 'lastSeenTime'");
            }
            if (columnTypes.get("lastSeenTime") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'lastSeenTime'");
            }
            if (!columnTypes.containsKey("latitude")) {
                throw new IllegalStateException("Missing column 'latitude'");
            }
            if (columnTypes.get("latitude") != ColumnType.DOUBLE) {
                throw new IllegalStateException("Invalid type 'double' for column 'latitude'");
            }
            if (!columnTypes.containsKey("longitude")) {
                throw new IllegalStateException("Missing column 'longitude'");
            }
            if (columnTypes.get("longitude") != ColumnType.DOUBLE) {
                throw new IllegalStateException("Invalid type 'double' for column 'longitude'");
            }
            if (!columnTypes.containsKey("radius")) {
                throw new IllegalStateException("Missing column 'radius'");
            }
            if (columnTypes.get("radius") != ColumnType.FLOAT) {
                throw new IllegalStateException("Invalid type 'float' for column 'radius'");
            }
            if (!columnTypes.containsKey("virtual")) {
                throw new IllegalStateException("Missing column 'virtual'");
            }
            if (columnTypes.get("virtual") != ColumnType.BOOLEAN) {
                throw new IllegalStateException("Invalid type 'boolean' for column 'virtual'");
            }
        }
    }

    public static List<String> getFieldNames() {
        return Arrays.asList("name", "minor", "major", "lastSeenTime", "latitude", "longitude", "radius", "virtual");
    }

    public static void populateUsingJsonObject(PersistentBeacon obj, JSONObject json)
        throws JSONException {
        boolean standalone = obj.realm == null;
        if (!json.isNull("name")) {
            obj.setName((String) json.getString("name"));
        }
        if (!json.isNull("minor")) {
            obj.setMinor((int) json.getInt("minor"));
        }
        if (!json.isNull("major")) {
            obj.setMajor((int) json.getInt("major"));
        }
        if (!json.isNull("lastSeenTime")) {
            obj.setLastSeenTime((long) json.getLong("lastSeenTime"));
        }
        if (!json.isNull("latitude")) {
            obj.setLatitude((double) json.getDouble("latitude"));
        }
        if (!json.isNull("longitude")) {
            obj.setLongitude((double) json.getDouble("longitude"));
        }
        if (!json.isNull("radius")) {
            obj.setRadius((float) json.getDouble("radius"));
        }
        if (!json.isNull("virtual")) {
            obj.setVirtual((boolean) json.getBoolean("virtual"));
        }
    }

    public static void populateUsingJsonStream(PersistentBeacon obj, JsonReader reader)
        throws IOException {
        boolean standalone = obj.realm == null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("name") && reader.peek() != JsonToken.NULL) {
                obj.setName((String) reader.nextString());
            } else if (name.equals("minor")  && reader.peek() != JsonToken.NULL) {
                obj.setMinor((int) reader.nextInt());
            } else if (name.equals("major")  && reader.peek() != JsonToken.NULL) {
                obj.setMajor((int) reader.nextInt());
            } else if (name.equals("lastSeenTime")  && reader.peek() != JsonToken.NULL) {
                obj.setLastSeenTime((long) reader.nextLong());
            } else if (name.equals("latitude")  && reader.peek() != JsonToken.NULL) {
                obj.setLatitude((double) reader.nextDouble());
            } else if (name.equals("longitude")  && reader.peek() != JsonToken.NULL) {
                obj.setLongitude((double) reader.nextDouble());
            } else if (name.equals("radius")  && reader.peek() != JsonToken.NULL) {
                obj.setRadius((float) reader.nextDouble());
            } else if (name.equals("virtual")  && reader.peek() != JsonToken.NULL) {
                obj.setVirtual((boolean) reader.nextBoolean());
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
    }

    public static PersistentBeacon copyOrUpdate(Realm realm, PersistentBeacon object, boolean update, Map<RealmObject,RealmObject> cache) {
        return copy(realm, object, update, cache);
    }

    public static PersistentBeacon copy(Realm realm, PersistentBeacon newObject, boolean update, Map<RealmObject,RealmObject> cache) {
        PersistentBeacon realmObject = realm.createObject(PersistentBeacon.class);
        cache.put(newObject, realmObject);
        realmObject.setName(newObject.getName() != null ? newObject.getName() : "");
        realmObject.setMinor(newObject.getMinor());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setLastSeenTime(newObject.getLastSeenTime());
        realmObject.setLatitude(newObject.getLatitude());
        realmObject.setLongitude(newObject.getLongitude());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setVirtual(newObject.isVirtual());
        return realmObject;
    }

    static PersistentBeacon update(Realm realm, PersistentBeacon realmObject, PersistentBeacon newObject, Map<RealmObject, RealmObject> cache) {
        realmObject.setName(newObject.getName() != null ? newObject.getName() : "");
        realmObject.setMinor(newObject.getMinor());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setLastSeenTime(newObject.getLastSeenTime());
        realmObject.setLatitude(newObject.getLatitude());
        realmObject.setLongitude(newObject.getLongitude());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setVirtual(newObject.isVirtual());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("PersistentBeacon = [");
        stringBuilder.append("{name:");
        stringBuilder.append(getName());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{minor:");
        stringBuilder.append(getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lastSeenTime:");
        stringBuilder.append(getLastSeenTime());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{latitude:");
        stringBuilder.append(getLatitude());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{longitude:");
        stringBuilder.append(getLongitude());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{radius:");
        stringBuilder.append(getRadius());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{virtual:");
        stringBuilder.append(isVirtual());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PersistentBeaconRealmProxy aPersistentBeacon = (PersistentBeaconRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aPersistentBeacon.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aPersistentBeacon.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aPersistentBeacon.row.getIndex()) return false;

        return true;
    }

}
