package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.MonitoringRegionRealm;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitoringRegionRealmRealmProxy extends MonitoringRegionRealm
    implements RealmObjectProxy {

    static final class MonitoringRegionRealmColumnInfo extends ColumnInfo {

        public final long uuidIndex;
        public final long majorIndex;

        MonitoringRegionRealmColumnInfo(String path, Table table) {
            final Map<String, Long> indicesMap = new HashMap<String, Long>(2);
            this.uuidIndex = getValidColumnIndex(path, table, "MonitoringRegionRealm", "uuid");
            indicesMap.put("uuid", this.uuidIndex);

            this.majorIndex = getValidColumnIndex(path, table, "MonitoringRegionRealm", "major");
            indicesMap.put("major", this.majorIndex);

            setIndicesMap(indicesMap);
        }
    }

    private final MonitoringRegionRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;
    static {
        List<String> fieldNames = new ArrayList<String>();
        fieldNames.add("uuid");
        fieldNames.add("major");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    MonitoringRegionRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (MonitoringRegionRealmColumnInfo) columnInfo;
    }

    @Override
    @SuppressWarnings("cast")
    public String getUuid() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(columnInfo.uuidIndex);
    }

    @Override
    public void setUuid(String value) {
        realm.checkIfValid();
        if (value == null) {
            row.setNull(columnInfo.uuidIndex);
            return;
        }
        row.setString(columnInfo.uuidIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public int getMajor() {
        realm.checkIfValid();
        return (int) row.getLong(columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        realm.checkIfValid();
        row.setLong(columnInfo.majorIndex, value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_MonitoringRegionRealm")) {
            Table table = transaction.getTable("class_MonitoringRegionRealm");
            table.addColumn(ColumnType.STRING, "uuid", Table.NULLABLE);
            table.addColumn(ColumnType.INTEGER, "major", Table.NOT_NULLABLE);
            table.addSearchIndex(table.getColumnIndex("major"));
            table.setPrimaryKey("major");
            return table;
        }
        return transaction.getTable("class_MonitoringRegionRealm");
    }

    public static MonitoringRegionRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_MonitoringRegionRealm")) {
            Table table = transaction.getTable("class_MonitoringRegionRealm");
            if (table.getColumnCount() != 2) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 2 but was " + table.getColumnCount());
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for (long i = 0; i < 2; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }

            final MonitoringRegionRealmColumnInfo columnInfo = new MonitoringRegionRealmColumnInfo(transaction.getPath(), table);

            if (!columnTypes.containsKey("uuid")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'uuid' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("uuid") != ColumnType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'uuid' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.uuidIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'uuid' is required. Either set @Required to field 'uuid' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != ColumnType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'major' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("major"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'major' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            return columnInfo;
        } else {
            throw new RealmMigrationNeededException(transaction.getPath(), "The MonitoringRegionRealm class is missing from the schema for this Realm.");
        }
    }

    public static String getTableName() {
        return "class_MonitoringRegionRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    @SuppressWarnings("cast")
    public static MonitoringRegionRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update)
        throws JSONException {
        MonitoringRegionRealm obj = null;
        if (update) {
            Table table = realm.getTable(MonitoringRegionRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("major")) {
                long rowIndex = table.findFirstLong(pkColumnIndex, json.getLong("major"));
                if (rowIndex != TableOrView.NO_MATCH) {
                    obj = new MonitoringRegionRealmRealmProxy(realm.getColumnInfo(MonitoringRegionRealm.class));
                    obj.realm = realm;
                    obj.row = table.getUncheckedRow(rowIndex);
                }
            }
        }
        if (obj == null) {
            obj = realm.createObject(MonitoringRegionRealm.class);
        }
        if (json.has("uuid")) {
            if (json.isNull("uuid")) {
                obj.setUuid(null);
            } else {
                obj.setUuid((String) json.getString("uuid"));
            }
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            } else {
                obj.setMajor((int) json.getInt("major"));
            }
        }
        return obj;
    }

    @SuppressWarnings("cast")
    public static MonitoringRegionRealm createUsingJsonStream(Realm realm, JsonReader reader)
        throws IOException {
        MonitoringRegionRealm obj = realm.createObject(MonitoringRegionRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("uuid")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setUuid(null);
                } else {
                    obj.setUuid((String) reader.nextString());
                }
            } else if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                } else {
                    obj.setMajor((int) reader.nextInt());
                }
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
        return obj;
    }

    public static MonitoringRegionRealm copyOrUpdate(Realm realm, MonitoringRegionRealm object, boolean update, Map<RealmObject,RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        MonitoringRegionRealm realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(MonitoringRegionRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            long rowIndex = table.findFirstLong(pkColumnIndex, object.getMajor());
            if (rowIndex != TableOrView.NO_MATCH) {
                realmObject = new MonitoringRegionRealmRealmProxy(realm.getColumnInfo(MonitoringRegionRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, (RealmObjectProxy) realmObject);
            } else {
                canUpdate = false;
            }
        }

        if (canUpdate) {
            return update(realm, realmObject, object, cache);
        } else {
            return copy(realm, object, update, cache);
        }
    }

    public static MonitoringRegionRealm copy(Realm realm, MonitoringRegionRealm newObject, boolean update, Map<RealmObject,RealmObjectProxy> cache) {
        MonitoringRegionRealm realmObject = realm.createObject(MonitoringRegionRealm.class, newObject.getMajor());
        cache.put(newObject, (RealmObjectProxy) realmObject);
        realmObject.setUuid(newObject.getUuid());
        realmObject.setMajor(newObject.getMajor());
        return realmObject;
    }

    static MonitoringRegionRealm update(Realm realm, MonitoringRegionRealm realmObject, MonitoringRegionRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setUuid(newObject.getUuid());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("MonitoringRegionRealm = [");
        stringBuilder.append("{uuid:");
        stringBuilder.append(getUuid() != null ? getUuid() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(getMajor());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MonitoringRegionRealmRealmProxy aMonitoringRegionRealm = (MonitoringRegionRealmRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aMonitoringRegionRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aMonitoringRegionRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aMonitoringRegionRealm.row.getIndex()) return false;

        return true;
    }

}
