/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.altbeacon.beacon.AltBeaconParser;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.BleNotAvailableException;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.logging.Loggers;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangedBeacon;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.simulator.BeaconSimulator;

@TargetApi(value=4)
public class BeaconManager {
    private static final String TAG = "BeaconManager";
    private Context mContext;
    protected static BeaconManager client = null;
    private final ConcurrentMap<BeaconConsumer, ConsumerInfo> consumers = new ConcurrentHashMap<BeaconConsumer, ConsumerInfo>();
    private Messenger serviceMessenger = null;
    protected RangeNotifier rangeNotifier = null;
    protected RangeNotifier dataRequestNotifier = null;
    protected MonitorNotifier monitorNotifier = null;
    private final ArrayList<Region> monitoredRegions = new ArrayList();
    private final ArrayList<Region> rangedRegions = new ArrayList();
    private final ArrayList<BeaconParser> beaconParsers = new ArrayList();
    private boolean mBackgroundMode = false;
    private boolean mBackgroundModeUninitialized = true;
    private static boolean sAndroidLScanningDisabled = false;
    private static boolean sManifestCheckingDisabled = false;
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 0L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    private long foregroundScanPeriod = 1100L;
    private long foregroundBetweenScanPeriod = 0L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;
    private ServiceConnection beaconServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            LogManager.d(BeaconManager.TAG, "we have a connection to the service now", new Object[0]);
            BeaconManager.this.serviceMessenger = new Messenger(service);
            ConcurrentMap concurrentMap = BeaconManager.this.consumers;
            synchronized (concurrentMap) {
                for (Map.Entry entry : BeaconManager.this.consumers.entrySet()) {
                    if (((ConsumerInfo)entry.getValue()).isConnected) continue;
                    ((BeaconConsumer)entry.getKey()).onBeaconServiceConnect();
                    ((ConsumerInfo)entry.getValue()).isConnected = true;
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            LogManager.e(BeaconManager.TAG, "onServiceDisconnected", new Object[0]);
            BeaconManager.this.serviceMessenger = null;
        }
    };
    protected static BeaconSimulator beaconSimulator;
    protected static String distanceModelUpdateUrl;
    protected static Class rssiFilterImplClass;

    @Deprecated
    public static void setDebug(boolean debug) {
        if (debug) {
            LogManager.setLogger(Loggers.verboseLogger());
            LogManager.setVerboseLoggingEnabled(true);
        } else {
            LogManager.setLogger(Loggers.empty());
            LogManager.setVerboseLoggingEnabled(false);
        }
    }

    public void setForegroundScanPeriod(long p) {
        this.foregroundScanPeriod = p;
    }

    public void setForegroundBetweenScanPeriod(long p) {
        this.foregroundBetweenScanPeriod = p;
    }

    public void setBackgroundScanPeriod(long p) {
        this.backgroundScanPeriod = p;
    }

    public void setBackgroundBetweenScanPeriod(long p) {
        this.backgroundBetweenScanPeriod = p;
    }

    public static BeaconManager getInstanceForApplication(Context context) {
        if (client == null) {
            LogManager.d(TAG, "BeaconManager instance creation", new Object[0]);
            client = new BeaconManager(context);
        }
        return client;
    }

    protected BeaconManager(Context context) {
        this.mContext = context;
        if (!sManifestCheckingDisabled) {
            this.verifyServiceDeclaration();
        }
        this.beaconParsers.add(new AltBeaconParser());
    }

    public List<BeaconParser> getBeaconParsers() {
        if (this.isAnyConsumerBound()) {
            return Collections.unmodifiableList(this.beaconParsers);
        }
        return this.beaconParsers;
    }

    @TargetApi(value=18)
    public boolean checkAvailability() throws BleNotAvailableException {
        if (Build.VERSION.SDK_INT < 18) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return ((BluetoothManager)this.mContext.getSystemService("bluetooth")).getAdapter().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(BeaconConsumer consumer) {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            ConsumerInfo consumerInfo = this.consumers.putIfAbsent(consumer, new ConsumerInfo());
            if (consumerInfo != null) {
                LogManager.d(TAG, "This consumer is already bound", new Object[0]);
            } else {
                LogManager.d(TAG, "This consumer is not bound.  binding: %s", consumer);
                Intent intent = new Intent(consumer.getApplicationContext(), BeaconService.class);
                consumer.bindService(intent, this.beaconServiceConnection, 1);
                LogManager.d(TAG, "consumer count is now: %s", this.consumers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(BeaconConsumer consumer) {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            if (this.consumers.containsKey(consumer)) {
                LogManager.d(TAG, "Unbinding", new Object[0]);
                consumer.unbindService(this.beaconServiceConnection);
                this.consumers.remove(consumer);
                if (this.consumers.size() == 0) {
                    this.serviceMessenger = null;
                }
            } else {
                LogManager.d(TAG, "This consumer is not bound to: %s", consumer);
                LogManager.d(TAG, "Bound consumers: ", new Object[0]);
                Set consumers = this.consumers.entrySet();
                for (Map.Entry consumerEntry : consumers) {
                    LogManager.d(TAG, String.valueOf(consumerEntry.getValue()), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound(BeaconConsumer consumer) {
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return consumer != null && this.consumers.get(consumer) != null && this.serviceMessenger != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnyConsumerBound() {
        ConcurrentMap<BeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return this.consumers.size() > 0 && this.serviceMessenger != null;
        }
    }

    public void setBackgroundMode(boolean backgroundMode) {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
        }
        this.mBackgroundModeUninitialized = false;
        if (backgroundMode != this.mBackgroundMode) {
            this.mBackgroundMode = backgroundMode;
            try {
                this.updateScanPeriods();
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Cannot contact service to set scan periods", new Object[0]);
            }
        }
    }

    public boolean isBackgroundModeUninitialized() {
        return this.mBackgroundModeUninitialized;
    }

    public void setRangeNotifier(RangeNotifier notifier) {
        this.rangeNotifier = notifier;
    }

    public void setMonitorNotifier(MonitorNotifier notifier) {
        this.monitorNotifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startRangingBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)2, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            this.rangedRegions.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopRangingBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)3, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region rangedRegion : this.rangedRegions) {
                if (!region.getUniqueId().equals(rangedRegion.getUniqueId())) continue;
                regionToRemove = rangedRegion;
            }
            this.rangedRegions.remove(regionToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)4, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            this.monitoredRegions.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopMonitoringBeaconsInRegion(Region region) throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)5, (int)0, (int)0);
        StartRMData obj = new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            Region regionToRemove = null;
            for (Region monitoredRegion : this.monitoredRegions) {
                if (!region.getUniqueId().equals(monitoredRegion.getUniqueId())) continue;
                regionToRemove = monitoredRegion;
            }
            this.monitoredRegions.remove(regionToRemove);
        }
    }

    @TargetApi(value=18)
    public void updateScanPeriods() throws RemoteException {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored", new Object[0]);
            return;
        }
        if (this.serviceMessenger == null) {
            throw new RemoteException("The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()");
        }
        Message msg = Message.obtain(null, (int)6, (int)0, (int)0);
        LogManager.d(TAG, "updating background flag to %s", this.mBackgroundMode);
        LogManager.d(TAG, "updating scan period to %s, %s", this.getScanPeriod(), this.getBetweenScanPeriod());
        StartRMData obj = new StartRMData(this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode);
        msg.obj = obj;
        this.serviceMessenger.send(msg);
    }

    private String callbackPackageName() {
        String packageName = this.mContext.getPackageName();
        LogManager.d(TAG, "callback packageName: %s", packageName);
        return packageName;
    }

    public MonitorNotifier getMonitoringNotifier() {
        return this.monitorNotifier;
    }

    public RangeNotifier getRangingNotifier() {
        return this.rangeNotifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> getMonitoredRegions() {
        ArrayList<Region> arrayList = this.monitoredRegions;
        synchronized (arrayList) {
            return new ArrayList<Region>(this.monitoredRegions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> getRangedRegions() {
        ArrayList<Region> arrayList = this.rangedRegions;
        synchronized (arrayList) {
            return new ArrayList<Region>(this.rangedRegions);
        }
    }

    @Deprecated
    public static void logDebug(String tag, String message) {
        LogManager.d(tag, message, new Object[0]);
    }

    @Deprecated
    public static void logDebug(String tag, String message, Throwable t) {
        LogManager.d(t, tag, message, new Object[0]);
    }

    public static String getDistanceModelUpdateUrl() {
        return distanceModelUpdateUrl;
    }

    public static void setDistanceModelUpdateUrl(String url) {
        distanceModelUpdateUrl = url;
    }

    public static void setRssiFilterImplClass(Class c) {
        rssiFilterImplClass = c;
    }

    public static Class getRssiFilterImplClass() {
        return rssiFilterImplClass;
    }

    public static void setUseTrackingCache(boolean useTrackingCache) {
        RangeState.setUseTrackingCache(useTrackingCache);
    }

    public void setMaxTrackingAge(int maxTrackingAge) {
        RangedBeacon.setMaxTrackinAge(maxTrackingAge);
    }

    public static void setBeaconSimulator(BeaconSimulator beaconSimulator) {
        BeaconManager.beaconSimulator = beaconSimulator;
    }

    public static BeaconSimulator getBeaconSimulator() {
        return beaconSimulator;
    }

    protected void setDataRequestNotifier(RangeNotifier notifier) {
        this.dataRequestNotifier = notifier;
    }

    protected RangeNotifier getDataRequestNotifier() {
        return this.dataRequestNotifier;
    }

    private long getScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundScanPeriod;
        }
        return this.foregroundScanPeriod;
    }

    private long getBetweenScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundBetweenScanPeriod;
        }
        return this.foregroundBetweenScanPeriod;
    }

    private void verifyServiceDeclaration() {
        Intent intent;
        PackageManager packageManager = this.mContext.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(this.mContext, BeaconService.class), 65536);
        if (resolveInfo.size() == 0) {
            throw new ServiceNotDeclaredException();
        }
    }

    public static boolean isAndroidLScanningDisabled() {
        return sAndroidLScanningDisabled;
    }

    public static void setAndroidLScanningDisabled(boolean disabled) {
        sAndroidLScanningDisabled = disabled;
    }

    public static void setsManifestCheckingDisabled(boolean disabled) {
        sManifestCheckingDisabled = disabled;
    }

    static {
        distanceModelUpdateUrl = "http://data.altbeacon.org/android-distance.json";
        rssiFilterImplClass = RunningAverageRssiFilter.class;
    }

    public class ServiceNotDeclaredException
    extends RuntimeException {
        public ServiceNotDeclaredException() {
            super("The BeaconService is not properly declared in AndroidManifest.xml.  If using Eclipse, please verify that your project.properties has manifestmerger.enabled=true");
        }
    }

    private class ConsumerInfo {
        public boolean isConnected = false;

        private ConsumerInfo() {
        }
    }
}

