package io.realm;


import android.util.JsonReader;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import io.proxsee.sdk.entity.MonitoringRegionRealm;
import io.proxsee.sdk.entity.ProxSeeBeaconRealm;

@io.realm.annotations.RealmModule
class DefaultRealmModuleMediator extends RealmProxyMediator {

    private static final Set<Class<? extends RealmObject>> MODEL_CLASSES;
    static {
        Set<Class<? extends RealmObject>> modelClasses = new HashSet<Class<? extends RealmObject>>();
        modelClasses.add(ProxSeeBeaconRealm.class);
        modelClasses.add(MonitoringRegionRealm.class);
        MODEL_CLASSES = Collections.unmodifiableSet(modelClasses);
    }

    @Override
    public Table createTable(Class<? extends RealmObject> clazz, ImplicitTransaction transaction) {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return ProxSeeBeaconRealmRealmProxy.initTable(transaction);
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return MonitoringRegionRealmRealmProxy.initTable(transaction);
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public ColumnInfo validateTable(Class<? extends RealmObject> clazz, ImplicitTransaction transaction) {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return ProxSeeBeaconRealmRealmProxy.validateTable(transaction);
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return MonitoringRegionRealmRealmProxy.validateTable(transaction);
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public List<String> getFieldNames(Class<? extends RealmObject> clazz) {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return ProxSeeBeaconRealmRealmProxy.getFieldNames();
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return MonitoringRegionRealmRealmProxy.getFieldNames();
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public String getTableName(Class<? extends RealmObject> clazz) {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return ProxSeeBeaconRealmRealmProxy.getTableName();
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return MonitoringRegionRealmRealmProxy.getTableName();
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public <E extends RealmObject> E newInstance(Class<E> clazz, ColumnInfo columnInfo) {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return clazz.cast(new ProxSeeBeaconRealmRealmProxy(columnInfo));
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return clazz.cast(new MonitoringRegionRealmRealmProxy(columnInfo));
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public Set<Class<? extends RealmObject>> getModelClasses() {
        return MODEL_CLASSES;
    }

    @Override
    public <E extends RealmObject> E copyOrUpdate(Realm realm, E obj, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        // This cast is correct because obj is either
        // generated by RealmProxy or the original type extending directly from RealmObject
        @SuppressWarnings("unchecked") Class<E> clazz = (Class<E>) ((obj instanceof RealmObjectProxy) ? obj.getClass().getSuperclass() : obj.getClass());

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return clazz.cast(ProxSeeBeaconRealmRealmProxy.copyOrUpdate(realm, (ProxSeeBeaconRealm) obj, update, cache));
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return clazz.cast(MonitoringRegionRealmRealmProxy.copyOrUpdate(realm, (MonitoringRegionRealm) obj, update, cache));
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public <E extends RealmObject> E createOrUpdateUsingJsonObject(Class<E> clazz, Realm realm, JSONObject json, boolean update)
        throws JSONException {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return clazz.cast(ProxSeeBeaconRealmRealmProxy.createOrUpdateUsingJsonObject(realm, json, update));
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return clazz.cast(MonitoringRegionRealmRealmProxy.createOrUpdateUsingJsonObject(realm, json, update));
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

    @Override
    public <E extends RealmObject> E createUsingJsonStream(Class<E> clazz, Realm realm, JsonReader reader)
        throws IOException {
        checkClass(clazz);

        if (clazz.equals(ProxSeeBeaconRealm.class)) {
            return clazz.cast(ProxSeeBeaconRealmRealmProxy.createUsingJsonStream(realm, reader));
        } else if (clazz.equals(MonitoringRegionRealm.class)) {
            return clazz.cast(MonitoringRegionRealmRealmProxy.createUsingJsonStream(realm, reader));
        } else {
            throw getMissingProxyClassException(clazz);
        }
    }

}
