package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.ProxSeeBeaconRealm;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProxSeeBeaconRealmRealmProxy extends ProxSeeBeaconRealm
    implements RealmObjectProxy {

    static final class ProxSeeBeaconRealmColumnInfo extends ColumnInfo {

        public final long idIndex;
        public final long majorIndex;
        public final long minorIndex;
        public final long nameIndex;
        public final long tokenizedTagsIndex;
        public final long lastSeenIndex;
        public final long virtualIndex;
        public final long latIndex;
        public final long lngIndex;
        public final long radiusIndex;
        public final long inRangeIndex;

        ProxSeeBeaconRealmColumnInfo(String path, Table table) {
            final Map<String, Long> indicesMap = new HashMap<String, Long>(11);
            this.idIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "id");
            indicesMap.put("id", this.idIndex);

            this.majorIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "major");
            indicesMap.put("major", this.majorIndex);

            this.minorIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "minor");
            indicesMap.put("minor", this.minorIndex);

            this.nameIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "name");
            indicesMap.put("name", this.nameIndex);

            this.tokenizedTagsIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "tokenizedTags");
            indicesMap.put("tokenizedTags", this.tokenizedTagsIndex);

            this.lastSeenIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "lastSeen");
            indicesMap.put("lastSeen", this.lastSeenIndex);

            this.virtualIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "virtual");
            indicesMap.put("virtual", this.virtualIndex);

            this.latIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "lat");
            indicesMap.put("lat", this.latIndex);

            this.lngIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "lng");
            indicesMap.put("lng", this.lngIndex);

            this.radiusIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "radius");
            indicesMap.put("radius", this.radiusIndex);

            this.inRangeIndex = getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "inRange");
            indicesMap.put("inRange", this.inRangeIndex);

            setIndicesMap(indicesMap);
        }
    }

    private final ProxSeeBeaconRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;
    static {
        List<String> fieldNames = new ArrayList<String>();
        fieldNames.add("id");
        fieldNames.add("major");
        fieldNames.add("minor");
        fieldNames.add("name");
        fieldNames.add("tokenizedTags");
        fieldNames.add("lastSeen");
        fieldNames.add("virtual");
        fieldNames.add("lat");
        fieldNames.add("lng");
        fieldNames.add("radius");
        fieldNames.add("inRange");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    ProxSeeBeaconRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (ProxSeeBeaconRealmColumnInfo) columnInfo;
    }

    @Override
    @SuppressWarnings("cast")
    public String getId() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(columnInfo.idIndex);
    }

    @Override
    public void setId(String value) {
        realm.checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field id to null.");
        }
        row.setString(columnInfo.idIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public int getMajor() {
        realm.checkIfValid();
        return (int) row.getLong(columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        realm.checkIfValid();
        row.setLong(columnInfo.majorIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public int getMinor() {
        realm.checkIfValid();
        return (int) row.getLong(columnInfo.minorIndex);
    }

    @Override
    public void setMinor(int value) {
        realm.checkIfValid();
        row.setLong(columnInfo.minorIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public String getName() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(columnInfo.nameIndex);
    }

    @Override
    public void setName(String value) {
        realm.checkIfValid();
        if (value == null) {
            row.setNull(columnInfo.nameIndex);
            return;
        }
        row.setString(columnInfo.nameIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public String getTokenizedTags() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(columnInfo.tokenizedTagsIndex);
    }

    @Override
    public void setTokenizedTags(String value) {
        realm.checkIfValid();
        if (value == null) {
            row.setNull(columnInfo.tokenizedTagsIndex);
            return;
        }
        row.setString(columnInfo.tokenizedTagsIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public Date getLastSeen() {
        realm.checkIfValid();
        if (row.isNull(columnInfo.lastSeenIndex)) {
            return null;
        }
        return (java.util.Date) row.getDate(columnInfo.lastSeenIndex);
    }

    @Override
    public void setLastSeen(Date value) {
        realm.checkIfValid();
        if (value == null) {
            row.setNull(columnInfo.lastSeenIndex);
            return;
        }
        row.setDate(columnInfo.lastSeenIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public boolean isVirtual() {
        realm.checkIfValid();
        return (boolean) row.getBoolean(columnInfo.virtualIndex);
    }

    @Override
    public void setVirtual(boolean value) {
        realm.checkIfValid();
        row.setBoolean(columnInfo.virtualIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public double getLat() {
        realm.checkIfValid();
        return (double) row.getDouble(columnInfo.latIndex);
    }

    @Override
    public void setLat(double value) {
        realm.checkIfValid();
        row.setDouble(columnInfo.latIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public double getLng() {
        realm.checkIfValid();
        return (double) row.getDouble(columnInfo.lngIndex);
    }

    @Override
    public void setLng(double value) {
        realm.checkIfValid();
        row.setDouble(columnInfo.lngIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public float getRadius() {
        realm.checkIfValid();
        return (float) row.getFloat(columnInfo.radiusIndex);
    }

    @Override
    public void setRadius(float value) {
        realm.checkIfValid();
        row.setFloat(columnInfo.radiusIndex, value);
    }

    @Override
    @SuppressWarnings("cast")
    public boolean isInRange() {
        realm.checkIfValid();
        return (boolean) row.getBoolean(columnInfo.inRangeIndex);
    }

    @Override
    public void setInRange(boolean value) {
        realm.checkIfValid();
        row.setBoolean(columnInfo.inRangeIndex, value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_ProxSeeBeaconRealm")) {
            Table table = transaction.getTable("class_ProxSeeBeaconRealm");
            table.addColumn(ColumnType.STRING, "id", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.INTEGER, "major", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.INTEGER, "minor", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.STRING, "name", Table.NULLABLE);
            table.addColumn(ColumnType.STRING, "tokenizedTags", Table.NULLABLE);
            table.addColumn(ColumnType.DATE, "lastSeen", Table.NULLABLE);
            table.addColumn(ColumnType.BOOLEAN, "virtual", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.DOUBLE, "lat", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.DOUBLE, "lng", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.FLOAT, "radius", Table.NOT_NULLABLE);
            table.addColumn(ColumnType.BOOLEAN, "inRange", Table.NOT_NULLABLE);
            table.addSearchIndex(table.getColumnIndex("id"));
            table.setPrimaryKey("id");
            return table;
        }
        return transaction.getTable("class_ProxSeeBeaconRealm");
    }

    public static ProxSeeBeaconRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_ProxSeeBeaconRealm")) {
            Table table = transaction.getTable("class_ProxSeeBeaconRealm");
            if (table.getColumnCount() != 11) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 11 but was " + table.getColumnCount());
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for (long i = 0; i < 11; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }

            final ProxSeeBeaconRealmColumnInfo columnInfo = new ProxSeeBeaconRealmColumnInfo(transaction.getPath(), table);

            if (!columnTypes.containsKey("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'id' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("id") != ColumnType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'id' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.idIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'id' does support null values in the existing Realm file. Remove @Required or @PrimaryKey from field 'id' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'id' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("id"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'id' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != ColumnType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("minor")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'minor' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("minor") != ColumnType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'minor' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.minorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'minor' does support null values in the existing Realm file. Use corresponding boxed type for field 'minor' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("name")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'name' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("name") != ColumnType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'name' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.nameIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'name' is required. Either set @Required to field 'name' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("tokenizedTags")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'tokenizedTags' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("tokenizedTags") != ColumnType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'tokenizedTags' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.tokenizedTagsIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'tokenizedTags' is required. Either set @Required to field 'tokenizedTags' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("lastSeen")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lastSeen' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lastSeen") != ColumnType.DATE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'Date' for field 'lastSeen' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.lastSeenIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lastSeen' is required. Either set @Required to field 'lastSeen' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("virtual")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'virtual' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("virtual") != ColumnType.BOOLEAN) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'boolean' for field 'virtual' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.virtualIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'virtual' does support null values in the existing Realm file. Use corresponding boxed type for field 'virtual' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lat")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lat' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lat") != ColumnType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lat' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.latIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lat' does support null values in the existing Realm file. Use corresponding boxed type for field 'lat' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lng")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lng' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lng") != ColumnType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lng' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.lngIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lng' does support null values in the existing Realm file. Use corresponding boxed type for field 'lng' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("radius")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'radius' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("radius") != ColumnType.FLOAT) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'float' for field 'radius' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.radiusIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'radius' does support null values in the existing Realm file. Use corresponding boxed type for field 'radius' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("inRange")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'inRange' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("inRange") != ColumnType.BOOLEAN) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'boolean' for field 'inRange' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.inRangeIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'inRange' does support null values in the existing Realm file. Use corresponding boxed type for field 'inRange' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            return columnInfo;
        } else {
            throw new RealmMigrationNeededException(transaction.getPath(), "The ProxSeeBeaconRealm class is missing from the schema for this Realm.");
        }
    }

    public static String getTableName() {
        return "class_ProxSeeBeaconRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    @SuppressWarnings("cast")
    public static ProxSeeBeaconRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update)
        throws JSONException {
        ProxSeeBeaconRealm obj = null;
        if (update) {
            Table table = realm.getTable(ProxSeeBeaconRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("id")) {
                long rowIndex = table.findFirstString(pkColumnIndex, json.getString("id"));
                if (rowIndex != TableOrView.NO_MATCH) {
                    obj = new ProxSeeBeaconRealmRealmProxy(realm.getColumnInfo(ProxSeeBeaconRealm.class));
                    obj.realm = realm;
                    obj.row = table.getUncheckedRow(rowIndex);
                }
            }
        }
        if (obj == null) {
            obj = realm.createObject(ProxSeeBeaconRealm.class);
        }
        if (json.has("id")) {
            if (json.isNull("id")) {
                obj.setId(null);
            } else {
                obj.setId((String) json.getString("id"));
            }
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            } else {
                obj.setMajor((int) json.getInt("major"));
            }
        }
        if (json.has("minor")) {
            if (json.isNull("minor")) {
                throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
            } else {
                obj.setMinor((int) json.getInt("minor"));
            }
        }
        if (json.has("name")) {
            if (json.isNull("name")) {
                obj.setName(null);
            } else {
                obj.setName((String) json.getString("name"));
            }
        }
        if (json.has("tokenizedTags")) {
            if (json.isNull("tokenizedTags")) {
                obj.setTokenizedTags(null);
            } else {
                obj.setTokenizedTags((String) json.getString("tokenizedTags"));
            }
        }
        if (json.has("lastSeen")) {
            if (json.isNull("lastSeen")) {
                obj.setLastSeen(null);
            } else {
                Object timestamp = json.get("lastSeen");
                if (timestamp instanceof String) {
                    obj.setLastSeen(JsonUtils.stringToDate((String) timestamp));
                } else {
                    obj.setLastSeen(new Date(json.getLong("lastSeen")));
                }
            }
        }
        if (json.has("virtual")) {
            if (json.isNull("virtual")) {
                throw new IllegalArgumentException("Trying to set non-nullable field virtual to null.");
            } else {
                obj.setVirtual((boolean) json.getBoolean("virtual"));
            }
        }
        if (json.has("lat")) {
            if (json.isNull("lat")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
            } else {
                obj.setLat((double) json.getDouble("lat"));
            }
        }
        if (json.has("lng")) {
            if (json.isNull("lng")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
            } else {
                obj.setLng((double) json.getDouble("lng"));
            }
        }
        if (json.has("radius")) {
            if (json.isNull("radius")) {
                throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
            } else {
                obj.setRadius((float) json.getDouble("radius"));
            }
        }
        if (json.has("inRange")) {
            if (json.isNull("inRange")) {
                throw new IllegalArgumentException("Trying to set non-nullable field inRange to null.");
            } else {
                obj.setInRange((boolean) json.getBoolean("inRange"));
            }
        }
        return obj;
    }

    @SuppressWarnings("cast")
    public static ProxSeeBeaconRealm createUsingJsonStream(Realm realm, JsonReader reader)
        throws IOException {
        ProxSeeBeaconRealm obj = realm.createObject(ProxSeeBeaconRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("id")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setId(null);
                } else {
                    obj.setId((String) reader.nextString());
                }
            } else if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                } else {
                    obj.setMajor((int) reader.nextInt());
                }
            } else if (name.equals("minor")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
                } else {
                    obj.setMinor((int) reader.nextInt());
                }
            } else if (name.equals("name")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setName(null);
                } else {
                    obj.setName((String) reader.nextString());
                }
            } else if (name.equals("tokenizedTags")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setTokenizedTags(null);
                } else {
                    obj.setTokenizedTags((String) reader.nextString());
                }
            } else if (name.equals("lastSeen")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setLastSeen(null);
                } else if (reader.peek() == JsonToken.NUMBER) {
                    long timestamp = reader.nextLong();
                    if (timestamp > -1) {
                        obj.setLastSeen(new Date(timestamp));
                    }
                } else {
                    obj.setLastSeen(JsonUtils.stringToDate(reader.nextString()));
                }
            } else if (name.equals("virtual")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field virtual to null.");
                } else {
                    obj.setVirtual((boolean) reader.nextBoolean());
                }
            } else if (name.equals("lat")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
                } else {
                    obj.setLat((double) reader.nextDouble());
                }
            } else if (name.equals("lng")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
                } else {
                    obj.setLng((double) reader.nextDouble());
                }
            } else if (name.equals("radius")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
                } else {
                    obj.setRadius((float) reader.nextDouble());
                }
            } else if (name.equals("inRange")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field inRange to null.");
                } else {
                    obj.setInRange((boolean) reader.nextBoolean());
                }
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
        return obj;
    }

    public static ProxSeeBeaconRealm copyOrUpdate(Realm realm, ProxSeeBeaconRealm object, boolean update, Map<RealmObject,RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        ProxSeeBeaconRealm realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(ProxSeeBeaconRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (object.getId() == null) {
                throw new IllegalArgumentException("Primary key value must not be null.");
            }
            long rowIndex = table.findFirstString(pkColumnIndex, object.getId());
            if (rowIndex != TableOrView.NO_MATCH) {
                realmObject = new ProxSeeBeaconRealmRealmProxy(realm.getColumnInfo(ProxSeeBeaconRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, (RealmObjectProxy) realmObject);
            } else {
                canUpdate = false;
            }
        }

        if (canUpdate) {
            return update(realm, realmObject, object, cache);
        } else {
            return copy(realm, object, update, cache);
        }
    }

    public static ProxSeeBeaconRealm copy(Realm realm, ProxSeeBeaconRealm newObject, boolean update, Map<RealmObject,RealmObjectProxy> cache) {
        ProxSeeBeaconRealm realmObject = realm.createObject(ProxSeeBeaconRealm.class, newObject.getId());
        cache.put(newObject, (RealmObjectProxy) realmObject);
        realmObject.setId(newObject.getId());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setName(newObject.getName());
        realmObject.setTokenizedTags(newObject.getTokenizedTags());
        realmObject.setLastSeen(newObject.getLastSeen());
        realmObject.setVirtual(newObject.isVirtual());
        realmObject.setLat(newObject.getLat());
        realmObject.setLng(newObject.getLng());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setInRange(newObject.isInRange());
        return realmObject;
    }

    static ProxSeeBeaconRealm update(Realm realm, ProxSeeBeaconRealm realmObject, ProxSeeBeaconRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setName(newObject.getName());
        realmObject.setTokenizedTags(newObject.getTokenizedTags());
        realmObject.setLastSeen(newObject.getLastSeen());
        realmObject.setVirtual(newObject.isVirtual());
        realmObject.setLat(newObject.getLat());
        realmObject.setLng(newObject.getLng());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setInRange(newObject.isInRange());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("ProxSeeBeaconRealm = [");
        stringBuilder.append("{id:");
        stringBuilder.append(getId());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{minor:");
        stringBuilder.append(getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{name:");
        stringBuilder.append(getName() != null ? getName() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{tokenizedTags:");
        stringBuilder.append(getTokenizedTags() != null ? getTokenizedTags() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lastSeen:");
        stringBuilder.append(getLastSeen() != null ? getLastSeen() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{virtual:");
        stringBuilder.append(isVirtual());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lat:");
        stringBuilder.append(getLat());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lng:");
        stringBuilder.append(getLng());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{radius:");
        stringBuilder.append(getRadius());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{inRange:");
        stringBuilder.append(isInRange());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProxSeeBeaconRealmRealmProxy aProxSeeBeaconRealm = (ProxSeeBeaconRealmRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aProxSeeBeaconRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aProxSeeBeaconRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aProxSeeBeaconRealm.row.getIndex()) return false;

        return true;
    }

}
