/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.UpdateMetadataRequest;
import io.proxsee.sdk.client.response.UpdateMetadataResponse;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.LocationStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.misc.Preference;
import io.proxsee.sdk.misc.Utils;
import java.util.HashMap;
import javax.inject.Inject;

public class DeviceStateMonitor
implements BluetoothStateListener,
LocationStateListener,
SDKEventListener {
    private final String BLUETOOTH_ENABLED = "bluetooth_enabled";
    private final String SDK_ENABLED = "sdk_enabled";
    private final String LOCATION_ENABLED = "location_enabled";
    private final String SDK_STARTED_METADATA_HASH = "SDK_STARTED_METADATA_HASH";
    private boolean sdkEnabled;
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    Preference preference;
    private final Callback<UpdateMetadataResponse> NIL_CALLBACK = new Callback<UpdateMetadataResponse>(){

        @Override
        public void onSuccess(UpdateMetadataResponse response) {
        }

        @Override
        public void onError(UpdateMetadataResponse response, Throwable e) {
        }
    };

    @Override
    public void onBluetoothTurnedOff() {
        if (!this.sdkEnabled) {
            return;
        }
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("bluetooth_enabled", false);
    }

    @Override
    public void onBluetoothTurnedOn() {
        if (!this.sdkEnabled) {
            return;
        }
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("bluetooth_enabled", true);
    }

    @Override
    public void onLocationServiceEnabled() {
        if (!this.sdkEnabled) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("location_enabled", true);
        new UpdateMetadataRequest(this.proxSeeContext, data).invoke(this.NIL_CALLBACK);
    }

    @Override
    public void onLocationServiceDisabled() {
        if (!this.sdkEnabled) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("location_enabled", false);
        new UpdateMetadataRequest(this.proxSeeContext, data).invoke(this.NIL_CALLBACK);
    }

    @Override
    public void onSDKStarting() {
        this.sdkEnabled = true;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sdk_enabled", this.sdkEnabled);
        data.put("bluetooth_enabled", Utils.isBluetoothAdapterOn());
        data.put("location_enabled", Utils.isLocationEnabled(this.proxSeeContext.getApplicationContext()));
        final String currentMetadataHash = Utils.createHash(data);
        String lastMetadataHash = this.preference.getString("SDK_STARTED_METADATA_HASH", null);
        if (currentMetadataHash.equals(lastMetadataHash)) {
            return;
        }
        new UpdateMetadataRequest(this.proxSeeContext, data).invoke(new Callback<UpdateMetadataResponse>(){

            @Override
            public void onSuccess(UpdateMetadataResponse response) {
                DeviceStateMonitor.this.preference.setString("SDK_STARTED_METADATA_HASH", currentMetadataHash);
            }

            @Override
            public void onError(UpdateMetadataResponse response, Throwable e) {
            }
        });
    }

    @Override
    public void onSDKStopping() {
        this.sdkEnabled = false;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sdk_enabled", this.sdkEnabled);
        new UpdateMetadataRequest(this.proxSeeContext, data).invoke(this.NIL_CALLBACK);
        this.preference.setString("SDK_STARTED_METADATA_HASH", null);
    }

    @Override
    public void onSDKReset() {
    }
}

