/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import io.proxsee.sdk.ProxSeeBeaconHandler;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.client.request.BeaconsAroundMeRequest;
import io.proxsee.sdk.client.request.ProxSeeRequest;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.entity.VirtualRegion;
import io.proxsee.sdk.entity.VirtualRegionRepository;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.virtual.VirtualBeaconManager;
import io.proxsee.sdk.virtual.VirtualRegionMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.altbeacon.beacon.Beacon;

public class ProxSeeBeaconMonitor
implements BeaconNearbyNotifier,
VirtualRegionMonitor,
ConnectionStateListener {
    private static final String TAG = ProxSeeBeaconMonitor.class.getSimpleName();
    private final Map<Pair<Integer, Integer>, ProxSeeBeacon> cachedBeacons = new HashMap<Pair<Integer, Integer>, ProxSeeBeacon>();
    private final Set<Pair<Integer, Integer>> blackListed = new HashSet<Pair<Integer, Integer>>();
    private Date lastTimeCacheRefreshed = new Date(0L);
    @Inject
    VirtualBeaconManager virtualBeaconManager;
    @Inject
    ProxSeeBeaconRepository proxSeeBeaconRepository;
    @Inject
    ProxSeeBeaconHandler beaconHandler;
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    VirtualRegionRepository virtualRegionRepository;

    @Override
    public void onDataConnectionAvailable() {
        Log.d((String)TAG, (String)"data connection available");
    }

    @Override
    public void onDataConnectionLost() {
        Log.d((String)TAG, (String)"data connection unavailable!");
    }

    @Override
    public void didEnterCircularRegion(String regionId) {
        VirtualRegion virtualRegion = this.virtualRegionRepository.findById(regionId);
        if (virtualRegion == null) {
            return;
        }
        ProxSeeBeacon virtualBeacon = this.findProxSeeBeacon(virtualRegion.getMajor(), virtualRegion.getMinor());
        if (virtualBeacon == null) {
            return;
        }
        Log.d((String)TAG, (String)("Did Enter Virtual Region " + virtualBeacon));
        List<ProxSeeBeacon> currentBeaconsInRange = Arrays.asList(virtualBeacon);
        List<ProxSeeBeacon> implicitCheckoutBeacons = this.proxSeeBeaconRepository.findAll();
        this.processBeaconsChange(currentBeaconsInRange, implicitCheckoutBeacons);
    }

    @Override
    public void didExitCircularRegion(String regionId) {
        VirtualRegion virtualRegion = this.virtualRegionRepository.findById(regionId);
        if (virtualRegion == null) {
            return;
        }
        ProxSeeBeacon virtualBeacon = this.findProxSeeBeacon(virtualRegion.getMajor(), virtualRegion.getMinor());
        if (virtualBeacon == null) {
            return;
        }
        Log.d((String)TAG, (String)("Did Exit Virtual Region" + virtualBeacon));
        List<ProxSeeBeacon> currentBeaconsInRange = this.proxSeeBeaconRepository.findAllWithVirtualFlag(false);
        List<ProxSeeBeacon> implicitCheckoutBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(true);
        implicitCheckoutBeacons.remove(virtualBeacon);
        this.processBeaconsChange(currentBeaconsInRange, implicitCheckoutBeacons);
    }

    @Override
    public void didChangeBeaconsNearby(Collection<Beacon> beacons) {
        ArrayList<ProxSeeBeacon> currentBeaconsInRange = new ArrayList<ProxSeeBeacon>(beacons.isEmpty() ? Collections.EMPTY_LIST : this.findProxSeeBeacons(beacons));
        List<ProxSeeBeacon> implicitCheckoutBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(true);
        this.processBeaconsChange(currentBeaconsInRange, implicitCheckoutBeacons);
    }

    private void processBeaconsChange(Collection<ProxSeeBeacon> currentBeaconsInRange, Collection<ProxSeeBeacon> implicitCheckoutBeacons) {
        List<ProxSeeBeacon> previousBeaconsInRange = this.proxSeeBeaconRepository.findAll();
        Log.d((String)TAG, (String)String.format("Current  Beacons %s", TextUtils.join((CharSequence)"-", currentBeaconsInRange)));
        Log.d((String)TAG, (String)String.format("Previous  Beacons %s", TextUtils.join((CharSequence)"-", previousBeaconsInRange)));
        Log.d((String)TAG, (String)String.format("Implicit Checkout  Beacons %s", TextUtils.join((CharSequence)"-", implicitCheckoutBeacons)));
        if (previousBeaconsInRange.containsAll(currentBeaconsInRange) && currentBeaconsInRange.containsAll(previousBeaconsInRange)) {
            Log.d((String)TAG, (String)String.format("BEACON STATE NOT CHANGED", new Object[0]));
            return;
        }
        Log.d((String)TAG, (String)String.format("BEACON STATE CHANGED", new Object[0]));
        Collection<ProxSeeBeacon> checkInBeacons = this.substract(currentBeaconsInRange, previousBeaconsInRange);
        Collection<ProxSeeBeacon> checkOutBeacons = this.substract(previousBeaconsInRange, currentBeaconsInRange);
        this.proxSeeBeaconRepository.deleteAll();
        this.proxSeeBeaconRepository.addOrUpdate(currentBeaconsInRange);
        Collection<ProxSeeBeacon> nonImplicitCheckout = this.substract(checkOutBeacons, implicitCheckoutBeacons);
        implicitCheckoutBeacons.remove(this.substract(implicitCheckoutBeacons, checkOutBeacons));
        Log.d((String)TAG, (String)String.format("Checkout implicit Beacons %s", TextUtils.join((CharSequence)"-", implicitCheckoutBeacons)));
        Log.d((String)TAG, (String)String.format("Checkout non implicit Beacons %s", TextUtils.join((CharSequence)"-", nonImplicitCheckout)));
        Log.d((String)TAG, (String)String.format("CheckIn Beacons %s", TextUtils.join((CharSequence)"-", checkInBeacons)));
        this.beaconHandler.checkOut(implicitCheckoutBeacons, true);
        this.beaconHandler.checkOut(nonImplicitCheckout, false);
        this.beaconHandler.checkIn(checkInBeacons);
        this.beaconHandler.processTagChanges(previousBeaconsInRange, currentBeaconsInRange);
    }

    public void reset() {
        this.blackListed.clear();
        this.cachedBeacons.clear();
        Log.d((String)TAG, (String)"ProxSeeBeaconMonitor has been reset!");
    }

    public void clearBlackListed() {
        this.blackListed.clear();
    }

    public void clearCachedBeacons() {
        this.lastTimeCacheRefreshed = new Date(0L);
        this.cachedBeacons.clear();
    }

    private Collection<ProxSeeBeacon> findProxSeeBeacons(Collection<Beacon> altBeacons) {
        this.clearCacheAndBlacklistedIfRequired();
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        ProxSeeBeacon proxSeeBeacon = null;
        for (Beacon beacon : altBeacons) {
            proxSeeBeacon = this.findProxSeeBeacon(beacon.getId2().toInt(), beacon.getId3().toInt());
            if (proxSeeBeacon == null) continue;
            proxSeeBeacon.setRssi(beacon.getRssi());
            proxSeeBeacons.add(proxSeeBeacon);
        }
        return proxSeeBeacons;
    }

    private ProxSeeBeacon findProxSeeBeacon(int major, int minor) {
        Pair majorMinor = Pair.create((Object)major, (Object)minor);
        if (this.blackListed.contains(majorMinor)) {
            return null;
        }
        ProxSeeBeacon proxSeeBeacon = this.cachedBeacons.get(majorMinor);
        if (proxSeeBeacon == null) {
            Collection<ProxSeeBeacon> beaconsAround = this.getBeaconsAround(major, minor);
            for (ProxSeeBeacon beaconAround : beaconsAround) {
                Pair beaconAroundMajorMinor = Pair.create((Object)beaconAround.getMajor(), (Object)beaconAround.getMinor());
                this.cachedBeacons.put((Pair<Integer, Integer>)beaconAroundMajorMinor, beaconAround);
                if (!beaconAroundMajorMinor.equals((Object)majorMinor)) continue;
                proxSeeBeacon = beaconAround;
            }
            if (proxSeeBeacon == null && !this.blackListed.contains(majorMinor)) {
                proxSeeBeacon = new ProxSeeBeacon(major, minor);
            }
        }
        return proxSeeBeacon;
    }

    private Collection<ProxSeeBeacon> getBeaconsAround(int major, int minor) {
        Log.d((String)TAG, (String)("Getting Beacons Around " + major + ":" + minor));
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        Pair majorMinor = Pair.create((Object)major, (Object)minor);
        if (this.blackListed.contains(majorMinor)) {
            return proxSeeBeacons;
        }
        ProxSeeRequest.RequestResult result = new BeaconsAroundMeRequest(this.proxSeeContext, major, minor).invokeSync();
        BeaconsAroundMeResponse response = (BeaconsAroundMeResponse)result.getResponse();
        if (result.isHasError()) {
            Log.e((String)TAG, (String)("Error fetching beacons around " + major + ":" + minor), (Throwable)result.getThrowable());
            if (response != null && response.getStatus() == 404) {
                this.blackListed.add((Pair<Integer, Integer>)majorMinor);
            }
        } else {
            HashSet<VirtualRegion> circularRegions = new HashSet<VirtualRegion>();
            for (ProxSeeBeacon beacon : (ProxSeeBeacon[])response.getBody()) {
                if (beacon.isVirtual()) {
                    VirtualRegion virtualRegion = new VirtualRegion(beacon);
                    circularRegions.add(virtualRegion);
                }
                proxSeeBeacons.add(beacon);
            }
            if (!circularRegions.isEmpty()) {
                this.virtualRegionRepository.deleteAll();
                this.virtualRegionRepository.addOrUpdate(circularRegions);
                this.virtualBeaconManager.startMonitoringRegions(circularRegions);
            }
        }
        return proxSeeBeacons;
    }

    private void clearCacheAndBlacklistedIfRequired() {
        if (this.lastTimeCacheRefreshed.getTime() < System.currentTimeMillis() - this.proxSeeContext.getCacheExpiry()) {
            this.blackListed.clear();
            this.cachedBeacons.clear();
            this.lastTimeCacheRefreshed = new Date();
        }
    }

    private Collection<ProxSeeBeacon> substract(Collection<ProxSeeBeacon> a, Collection<ProxSeeBeacon> b) {
        ArrayList<ProxSeeBeacon> col = new ArrayList<ProxSeeBeacon>();
        col.addAll(a);
        col.removeAll(b);
        return col;
    }

    public Collection<ProxSeeBeacon> getCachedBeacons() {
        return new ArrayList<ProxSeeBeacon>(this.cachedBeacons.values());
    }

    public Collection<Pair<Integer, Integer>> getBlackListedBeacons() {
        return new ArrayList<Pair<Integer, Integer>>(this.blackListed);
    }
}

