/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.dagger;

import dagger.ObjectGraph;
import java.util.HashMap;

public class Injector {
    private static Injector INSTANCE = new Injector();
    private ObjectGraph objectGraph;
    private HashMap<String, ObjectGraph> childGraph = new HashMap();

    private Injector() {
    }

    public static void init(Object module) {
        Injector.init(new Object[]{module});
    }

    public static void init(Object[] modules) {
        if (Injector.INSTANCE.objectGraph != null) {
            throw new RuntimeException("ObjectGraph was already initialized");
        }
        Injector.INSTANCE.objectGraph = ObjectGraph.create((Object[])modules);
    }

    public static <T> T inject(T object) {
        return (T)Injector.INSTANCE.objectGraph.inject(object);
    }

    public static ObjectGraph plus(String key, Object ... module) {
        if (Injector.INSTANCE.childGraph.containsKey(key)) {
            return Injector.INSTANCE.childGraph.get(key);
        }
        ObjectGraph g = Injector.INSTANCE.objectGraph.plus(module);
        Injector.INSTANCE.childGraph.put(key, g);
        return g;
    }

    public static void destroy(String key) {
        if (Injector.INSTANCE.childGraph.containsKey(key)) {
            Injector.INSTANCE.childGraph.remove(key);
        }
    }
}

