/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.dagger;

import android.content.Context;
import android.os.Handler;
import dagger.Module;
import dagger.Provides;
import io.proxsee.sdk.DeviceStateMonitor;
import io.proxsee.sdk.ProxSeeBeaconConsumer;
import io.proxsee.sdk.ProxSeeBeaconHandler;
import io.proxsee.sdk.ProxSeeBeaconMonitor;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.ProxSeeOfflineHandler;
import io.proxsee.sdk.ProxSeePermissionManager;
import io.proxsee.sdk.ProxSeeSDKManager;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyMonitor;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.broadcast.ProxSeeBroadcaster;
import io.proxsee.sdk.broadcastreceiver.BluetoothBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.ConnectionBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.LocationBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.SDKStateBroadcastReceiver;
import io.proxsee.sdk.cache.InternalCache;
import io.proxsee.sdk.dagger.Injector;
import io.proxsee.sdk.entity.HandshakeRepository;
import io.proxsee.sdk.entity.MonitoringRegionRepository;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.entity.Session;
import io.proxsee.sdk.entity.VirtualRegionRepository;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.listener.LocationStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.misc.Preference;
import io.proxsee.sdk.service.ProxSeeRealBeaconService;
import io.proxsee.sdk.service.ProxSeeService;
import io.proxsee.sdk.service.ProxSeeVirtualBeaconService;
import io.proxsee.sdk.virtual.VirtualBeaconConsumer;
import io.proxsee.sdk.virtual.VirtualBeaconManager;
import io.proxsee.sdk.virtual.VirtualRegionMonitor;
import javax.inject.Named;
import javax.inject.Singleton;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;

@Module(injects={ProxSeeSDKManager.class, ProxSeeRealBeaconService.class, ProxSeeVirtualBeaconService.class, ProxSeeBeaconConsumer.class, ProxSeeBeaconMonitor.class, ProxSeeBeaconHandler.class, MonitoringRegionRepository.class, ProxSeeBeaconRepository.class, InternalCache.class, HandshakeRepository.class, ProxSeeOfflineHandler.class, DeviceStateMonitor.class, VirtualRegionRepository.class, ProxSeeBroadcaster.class, BeaconNearbyMonitor.class}, library=true)
public class ProxSeeSDKModule {
    private final ProxSeeContext proxSeeContext;
    private final ConnectionBroadcastReceiver connectionBroadcastReceiver;
    private final BluetoothBroadcastReceiver bluetoothBroadcastReceiver;
    private final SDKStateBroadcastReceiver sdkStateBroadcastReceiver;
    private final LocationBroadcastReceiver locationBroadcastReceiver;
    private final Handler proxseeSDKHandler;

    public ProxSeeSDKModule(ProxSeeContext context, Handler handler) {
        this.proxSeeContext = context;
        this.proxseeSDKHandler = handler;
        this.sdkStateBroadcastReceiver = new SDKStateBroadcastReceiver(context.getApplicationContext(), handler);
        this.connectionBroadcastReceiver = new ConnectionBroadcastReceiver(context.getApplicationContext(), handler);
        this.bluetoothBroadcastReceiver = new BluetoothBroadcastReceiver(context.getApplicationContext(), handler);
        this.locationBroadcastReceiver = new LocationBroadcastReceiver(context.getApplicationContext(), handler);
    }

    private <T> T decorate(T obj) {
        if (obj instanceof BluetoothStateListener) {
            this.bluetoothBroadcastReceiver.addListener((BluetoothStateListener)obj);
        }
        if (obj instanceof ConnectionStateListener) {
            this.connectionBroadcastReceiver.addListener((ConnectionStateListener)obj);
        }
        if (obj instanceof SDKEventListener) {
            this.sdkStateBroadcastReceiver.addListener((SDKEventListener)obj);
        }
        if (obj instanceof LocationStateListener) {
            this.locationBroadcastReceiver.addListener((LocationStateListener)obj);
        }
        return obj;
    }

    @Provides
    @Singleton
    ProxSeeContext provideProxSeeContext() {
        return this.proxSeeContext;
    }

    @Provides
    @Singleton
    Context provideContext() {
        return this.proxSeeContext.getApplicationContext();
    }

    @Provides
    @Singleton
    ProxSeeBroadcaster providerProxSeeBroadcaster(Context context) {
        return new ProxSeeBroadcaster(context);
    }

    @Provides
    @Singleton
    BeaconManager providerBeaconManager(Context context) {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication((Context)context);
        beaconManager.setForegroundScanPeriod(this.proxSeeContext.getBluetoothScanPeriod());
        beaconManager.setForegroundBetweenScanPeriod(this.proxSeeContext.getBluetoothScanBetweenPeriod());
        beaconManager.setBackgroundScanPeriod(this.proxSeeContext.getBluetoothScanPeriod());
        beaconManager.setBackgroundBetweenScanPeriod(this.proxSeeContext.getBluetoothScanBetweenPeriod());
        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(this.proxSeeContext.getBeaconLayout()));
        return beaconManager;
    }

    @Provides
    @Singleton
    VirtualBeaconManager providerVirtualBeaconManager(ProxSeeContext context, ProxSeePermissionManager proxSeePermissionManager) {
        return this.decorate(new VirtualBeaconManager(context, this.proxseeSDKHandler, proxSeePermissionManager));
    }

    @Provides
    @Singleton
    Session providerSession(Context context) {
        return Session.getInstance(context);
    }

    @Provides
    @Singleton
    MonitoringRegionRepository providerMonitoringRegionRepository() {
        return this.decorate(Injector.inject(new MonitoringRegionRepository()));
    }

    @Provides
    @Singleton
    BeaconNearbyMonitor providerBeaconNearbyMonitor() {
        return this.decorate(Injector.inject(new BeaconNearbyMonitor()));
    }

    @Provides
    @Singleton
    VirtualRegionRepository providerVirtualRegionRepository() {
        return this.decorate(Injector.inject(new VirtualRegionRepository()));
    }

    @Provides
    @Singleton
    HandshakeRepository providerHandshakeRepository() {
        return this.decorate(Injector.inject(new HandshakeRepository()));
    }

    @Provides
    @Singleton
    ProxSeeOfflineHandler providerProxSeeOfflineHandler() {
        return this.decorate(Injector.inject(new ProxSeeOfflineHandler()));
    }

    @Provides
    @Singleton
    ProxSeeBeaconRepository providerProxSeeBeaconRepository() {
        return this.decorate(Injector.inject(new ProxSeeBeaconRepository()));
    }

    @Provides
    @Singleton
    ProxSeeBeaconHandler providerProxSeeBeaconHandler() {
        return this.decorate(Injector.inject(new ProxSeeBeaconHandler()));
    }

    @Provides
    @Singleton
    ProxSeeBeaconConsumer providerProxSeeBeaconConsumer() {
        return this.decorate(Injector.inject(new ProxSeeBeaconConsumer()));
    }

    @Provides
    @Singleton
    BeaconNearbyNotifier providerBeaconNearbyNotifier(ProxSeeBeaconMonitor monitor) {
        return monitor;
    }

    @Provides
    @Singleton
    BeaconConsumer providerBeaconConsumer(ProxSeeBeaconConsumer consumer) {
        return consumer;
    }

    @Provides
    @Singleton
    VirtualBeaconConsumer providerVirtualBeaconConsumer(ProxSeeBeaconConsumer consumer) {
        return consumer;
    }

    @Provides
    @Singleton
    ProxSeeBeaconMonitor providerProxSeeBeaconMonitor() {
        return this.decorate(Injector.inject(new ProxSeeBeaconMonitor()));
    }

    @Provides
    @Singleton
    VirtualRegionMonitor providerVirtualRegionMonitor(ProxSeeBeaconMonitor monitor) {
        return monitor;
    }

    @Provides
    @Singleton
    @Named(value="Real")
    ProxSeeService providerProxSeeRealBeaconService() {
        return this.decorate(Injector.inject(new ProxSeeRealBeaconService()));
    }

    @Provides
    @Singleton
    @Named(value="Virtual")
    ProxSeeService providerProxSeeVirtualBeaconService() {
        return this.decorate(Injector.inject(new ProxSeeVirtualBeaconService()));
    }

    @Provides
    @Singleton
    Preference providerInternalCache(Context context) {
        return new Preference(context);
    }

    @Provides
    @Singleton
    InternalCache providerInternalCache() {
        return this.decorate(Injector.inject(new InternalCache()));
    }

    @Provides
    @Singleton
    DeviceStateMonitor providerDeviceStateMonitor() {
        return this.decorate(Injector.inject(new DeviceStateMonitor()));
    }

    @Provides
    @Singleton
    Handler providerProxSeeSDKHandler() {
        return this.proxseeSDKHandler;
    }

    @Provides
    @Singleton
    ProxSeePermissionManager providerProxSeePermissionManager() {
        return new ProxSeePermissionManager();
    }
}

