/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.service;

import android.content.Context;
import android.util.Log;
import io.proxsee.sdk.listener.LocationStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.misc.Utils;
import io.proxsee.sdk.service.ProxSeeService;
import io.proxsee.sdk.virtual.VirtualBeaconConsumer;
import io.proxsee.sdk.virtual.VirtualBeaconManager;
import io.proxsee.sdk.virtual.VirtualRegionMonitor;
import javax.inject.Inject;

public class ProxSeeVirtualBeaconService
implements ProxSeeService,
LocationStateListener,
SDKEventListener {
    private static final String TAG = ProxSeeVirtualBeaconService.class.getSimpleName();
    private boolean started;
    private boolean sdkEnabled;
    @Inject
    VirtualBeaconManager virtualBeaconManager;
    @Inject
    VirtualBeaconConsumer virtualBeaconConsumer;
    @Inject
    VirtualRegionMonitor regionMonitor;
    @Inject
    Context context;

    @Override
    public void start() {
        if (!this.isRunning()) {
            if (Utils.isLocationEnabled(this.context)) {
                this.virtualBeaconManager.setVirtualRegionMonitor(this.regionMonitor);
                this.virtualBeaconManager.bind(this.virtualBeaconConsumer);
                this.started = true;
                Log.d((String)TAG, (String)"ProxSeeVirtualBeaconService has started...");
            } else {
                Log.w((String)TAG, (String)"ProxSeeVirtualBeaconService failed to start with location service currently turned off...the service will automatically start once location service is turned on.");
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.virtualBeaconManager.unbind(this.virtualBeaconConsumer);
            this.virtualBeaconManager.setVirtualRegionMonitor(null);
            this.started = false;
            Log.d((String)TAG, (String)"ProxSeeVirtualBeaconService has been stopped!");
        }
    }

    @Override
    public void onLocationServiceEnabled() {
        if (!this.sdkEnabled) {
            return;
        }
        this.start();
    }

    @Override
    public void onLocationServiceDisabled() {
        if (!this.sdkEnabled) {
            return;
        }
        this.stop();
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public void onSDKStarting() {
        this.sdkEnabled = true;
    }

    @Override
    public void onSDKStopping() {
        this.sdkEnabled = false;
    }

    @Override
    public void onSDKReset() {
    }
}

