/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.virtual;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.ProxSeePermissionManager;
import io.proxsee.sdk.model.CircularRegion;
import io.proxsee.sdk.virtual.VirtualBeaconConsumer;
import io.proxsee.sdk.virtual.VirtualRegionMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class VirtualBeaconManager
extends BroadcastReceiver
implements ResultCallback<Status>,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG = VirtualBeaconManager.class.getSimpleName();
    private static final String ACTION_GEOFENCE_TRANSITION = "io.proxsee.sdk.ACTION_GEOFENCE_TRANSITION";
    private final GoogleApiClient googleApiClient;
    private final PendingIntent geofencePendingIntent;
    private VirtualRegionMonitor virtualRegionMonitor;
    private VirtualBeaconConsumer virtualBeaconConsumer;
    private Handler proxseeSDKHandler;
    private ProxSeeContext proxSeeContext;
    private ProxSeePermissionManager proxSeePermissionManager;

    public VirtualBeaconManager(ProxSeeContext proxSeeContext, Handler handler, ProxSeePermissionManager proxSeePermissionManager) {
        Context context = proxSeeContext.getApplicationContext();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.geofencePendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_GEOFENCE_TRANSITION), (int)0x8000000);
        this.proxseeSDKHandler = handler;
        this.proxSeeContext = proxSeeContext;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_GEOFENCE_TRANSITION);
        context.registerReceiver((BroadcastReceiver)this, filter);
        this.proxSeePermissionManager = proxSeePermissionManager;
    }

    public void setVirtualRegionMonitor(VirtualRegionMonitor notifier) {
        this.virtualRegionMonitor = notifier;
    }

    public void unbind(VirtualBeaconConsumer virtualBeaconConsumer) {
        this.googleApiClient.disconnect();
    }

    public void bind(VirtualBeaconConsumer virtualBeaconConsumer) {
        this.virtualBeaconConsumer = virtualBeaconConsumer;
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
        }
    }

    public void startMonitoringRegions(Set<? extends CircularRegion> regions) {
        if (!this.googleApiClient.isConnected()) {
            return;
        }
        if (!this.proxSeePermissionManager.isPermissionGranted(this.proxSeeContext.getApplicationContext())) {
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent);
        if (regions != null && !regions.isEmpty()) {
            ArrayList<Geofence> geofences = new ArrayList<Geofence>();
            for (CircularRegion circularRegion : regions) {
                geofences.add(new Geofence.Builder().setRequestId(circularRegion.getId()).setCircularRegion(circularRegion.getLat(), circularRegion.getLng(), circularRegion.getRadius()).setExpirationDuration(-1L).setTransitionTypes(3).setNotificationResponsiveness(this.proxSeeContext.getGeofenceNotificationResponsiveness()).build());
                Log.d((String)TAG, (String)("Monitoring circular region: " + circularRegion));
            }
            GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
            builder.addGeofences(geofences);
            LocationServices.GeofencingApi.addGeofences(this.googleApiClient, builder.build(), this.geofencePendingIntent).setResultCallback((ResultCallback)this);
        }
    }

    public void onResult(Status status) {
        if (!status.isSuccess()) {
            switch (status.getStatusCode()) {
                default: 
            }
        }
    }

    public void onReceive(Context context, Intent intent) {
        final GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                if (VirtualBeaconManager.this.virtualRegionMonitor != null) {
                    if (geofencingEvent.hasError()) {
                        Log.e((String)TAG, (String)("Error while retrieving event, code: " + geofencingEvent.getErrorCode()));
                    } else {
                        Iterator i$ = geofencingEvent.getTriggeringGeofences().iterator();
                        if (i$.hasNext()) {
                            Geofence cur = (Geofence)i$.next();
                            switch (geofencingEvent.getGeofenceTransition()) {
                                case 1: {
                                    VirtualBeaconManager.this.virtualRegionMonitor.didEnterCircularRegion(cur.getRequestId());
                                    break;
                                }
                                case 2: {
                                    VirtualBeaconManager.this.virtualRegionMonitor.didExitCircularRegion(cur.getRequestId());
                                    break;
                                }
                                default: {
                                    Log.e((String)TAG, (String)("Invalid transition type: " + geofencingEvent.getGeofenceTransition()));
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public void onConnected(Bundle bundle) {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Connection established!");
                if (VirtualBeaconManager.this.virtualBeaconConsumer != null) {
                    VirtualBeaconManager.this.virtualBeaconConsumer.onVirtualBeaconServiceConnect();
                }
            }
        });
    }

    public void onConnectionSuspended(int i) {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Connection suspended");
            }
        });
    }

    public void onConnectionFailed(final ConnectionResult connectionResult) {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.e((String)TAG, (String)("Connection failed: ConnectionResult.getErrorCode() = " + connectionResult.getErrorCode()));
            }
        });
    }
}

