/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.beaconsnearby;

import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;

public class BeaconNearbyMonitor
implements RangeNotifier,
SDKEventListener,
BluetoothStateListener {
    private static final String TAG = BeaconNearbyMonitor.class.getSimpleName();
    @Inject
    Handler handler;
    @Inject
    ProxSeeContext proxSeeContext;
    private Object LOCK = new Object();
    private Collection<NearbyBeacon> currentRangingBeacons = new HashSet<NearbyBeacon>();
    private Collection<NearbyBeacon> previousRangingBeacons = new HashSet<NearbyBeacon>();
    private BeaconNearbyNotifier notifier;
    private boolean initialised = true;
    private int currentHit = 0;
    private long cycleDuration = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
        Object object = this.LOCK;
        synchronized (object) {
            Log.d((String)TAG, (String)String.format("Iteration %d with beacon in range %s", this.currentHit, TextUtils.join((CharSequence)"-", collection)));
            for (Beacon beacon : collection) {
                this.currentRangingBeacons.add(new NearbyBeacon(beacon));
            }
            Long now = System.currentTimeMillis();
            if (this.cycleDuration == 0L) {
                this.cycleDuration = now;
            }
            if (++this.currentHit < this.proxSeeContext.getIterationPerCycle() || now - this.cycleDuration < this.proxSeeContext.getBluetoothScanBetweenPeriod() * (long)this.proxSeeContext.getIterationPerCycle()) {
                return;
            }
            Log.d((String)TAG, (String)String.format("Process end of Cycle", new Object[0]));
            Collection<NearbyBeacon> nonExpiredBeacons = this.nonExpiredBeacons();
            Log.d((String)TAG, (String)String.format("Appending non expired beacons %s", TextUtils.join((CharSequence)"-", nonExpiredBeacons)));
            this.currentRangingBeacons.addAll(nonExpiredBeacons);
            Collection<NearbyBeacon> beaconsToPost = this.currentRangingBeacons;
            boolean hasChanged = this.hasCycleChanged();
            this.resetCycle();
            if (!hasChanged) {
                Log.d((String)TAG, (String)"Cycle End, NO CHANGES");
                return;
            }
            Log.d((String)TAG, (String)("Cycle End, POSTING CHANGES " + TextUtils.join((CharSequence)"-", beaconsToPost)));
            this.notifyChange();
        }
    }

    private Collection<NearbyBeacon> nonExpiredBeacons() {
        Collection<NearbyBeacon> noLongerSeenBeacons = this.substract(this.previousRangingBeacons, this.currentRangingBeacons);
        HashSet<NearbyBeacon> nonExpiredBeacon = new HashSet<NearbyBeacon>();
        for (NearbyBeacon nbBeacon : noLongerSeenBeacons) {
            boolean hasExpired = ++nbBeacon.numberOfExitCycles >= this.proxSeeContext.getCycleExitExpireCount();
            if (hasExpired) continue;
            nonExpiredBeacon.add(nbBeacon);
        }
        return nonExpiredBeacon;
    }

    private boolean hasCycleChanged() {
        return this.initialised || !this.previousRangingBeacons.containsAll(this.currentRangingBeacons) || !this.currentRangingBeacons.containsAll(this.previousRangingBeacons);
    }

    private void resetCycle() {
        this.initialised = false;
        this.previousRangingBeacons = this.currentRangingBeacons;
        this.currentRangingBeacons = new HashSet<NearbyBeacon>();
        this.currentHit = 0;
        this.cycleDuration = 0L;
    }

    private void notifyChange() {
        final Collection<Beacon> convertedBeacons = this.convert(this.previousRangingBeacons);
        if (this.notifier != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    BeaconNearbyMonitor.this.notifier.didChangeBeaconsNearby(convertedBeacons);
                }
            });
        }
    }

    private Collection<Beacon> convert(Collection<NearbyBeacon> nBeacons) {
        HashSet<Beacon> beacons = new HashSet<Beacon>();
        for (NearbyBeacon nb : nBeacons) {
            beacons.add(nb.beacon);
        }
        return beacons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this.previousRangingBeacons = new HashSet<NearbyBeacon>();
            this.currentRangingBeacons = new HashSet<NearbyBeacon>();
            this.currentHit = 0;
            this.cycleDuration = 0L;
        }
    }

    public void setBeaconNearbyNotifier(BeaconNearbyNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void onSDKStarting() {
    }

    @Override
    public void onSDKStopping() {
        this.resetAll();
    }

    @Override
    public void onSDKReset() {
    }

    private Collection<NearbyBeacon> substract(Collection<NearbyBeacon> a, Collection<NearbyBeacon> b) {
        ArrayList<NearbyBeacon> col = new ArrayList<NearbyBeacon>();
        col.addAll(a);
        col.removeAll(b);
        return col;
    }

    @Override
    public void onBluetoothTurnedOff() {
        this.resetAll();
    }

    @Override
    public void onBluetoothTurnedOn() {
    }

    private static class NearbyBeacon {
        private int numberOfExitCycles;
        private Beacon beacon;

        public NearbyBeacon(Beacon beacon) {
            this.beacon = beacon;
            this.numberOfExitCycles = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NearbyBeacon)) {
                return false;
            }
            NearbyBeacon that = (NearbyBeacon)o;
            return that.beacon.equals((Object)this.beacon);
        }

        public int hashCode() {
            return this.beacon.hashCode();
        }

        public String toString() {
            return "NearbyBeacon{major=" + this.beacon.getId2().toString() + ", minor=" + this.beacon.getId3().toString() + '}';
        }
    }
}

