/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.broadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import io.proxsee.sdk.listener.LocationStateListener;
import io.proxsee.sdk.misc.Utils;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class LocationBroadcastReceiver {
    private State lastState;
    private final Set<LocationStateListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public LocationBroadcastReceiver(Context context, Handler handler) {
        this.lastState = this.getLocationState(context);
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (LocationBroadcastReceiver.this.listeners.isEmpty()) {
                    return;
                }
                State currentState = LocationBroadcastReceiver.this.getLocationState(context);
                if (LocationBroadcastReceiver.this.lastState != currentState) {
                    LocationBroadcastReceiver.this.lastState = currentState;
                    switch (currentState) {
                        case ENABLED: {
                            for (LocationStateListener listener : LocationBroadcastReceiver.this.listeners) {
                                listener.onLocationServiceEnabled();
                            }
                            break;
                        }
                        case DISABLED: {
                            for (LocationStateListener listener : LocationBroadcastReceiver.this.listeners) {
                                listener.onLocationServiceDisabled();
                            }
                            break;
                        }
                    }
                }
            }
        };
        context.registerReceiver(receiver, new IntentFilter("android.location.PROVIDERS_CHANGED"), null, handler);
    }

    public void addListener(LocationStateListener listener) {
        this.listeners.add(listener);
    }

    private State getLocationState(Context context) {
        return Utils.isLocationEnabled(context) ? State.ENABLED : State.DISABLED;
    }

    private static enum State {
        ENABLED,
        DISABLED;

    }
}

