/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.broadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import io.proxsee.sdk.intent.SDKReset;
import io.proxsee.sdk.intent.SDKStarted;
import io.proxsee.sdk.intent.SDKStopped;
import io.proxsee.sdk.listener.SDKEventListener;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class SDKStateBroadcastReceiver {
    private State lastState;
    private final Set<SDKEventListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public SDKStateBroadcastReceiver(Context context, Handler handler) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(SDKStarted.ACTION_STATE_STARTED);
        filter.addAction(SDKStopped.ACTION_STATE_STOPPED);
        filter.addAction(SDKReset.ACTION_STATE_RESET);
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                State currentState;
                if (SDKStateBroadcastReceiver.this.listeners.isEmpty()) {
                    return;
                }
                State state = intent.getAction().equals(SDKStarted.ACTION_STATE_STARTED) ? State.STARTED : (currentState = intent.getAction().equals(SDKStopped.ACTION_STATE_STOPPED) ? State.STOPPED : State.RESET);
                if (SDKStateBroadcastReceiver.this.lastState != currentState) {
                    switch (currentState) {
                        case STARTED: {
                            for (SDKEventListener listener : SDKStateBroadcastReceiver.this.listeners) {
                                listener.onSDKStarting();
                            }
                            break;
                        }
                        case STOPPED: {
                            for (SDKEventListener listener : SDKStateBroadcastReceiver.this.listeners) {
                                listener.onSDKStopping();
                            }
                            break;
                        }
                        case RESET: {
                            for (SDKEventListener listener : SDKStateBroadcastReceiver.this.listeners) {
                                listener.onSDKReset();
                            }
                            break;
                        }
                    }
                }
                SDKStateBroadcastReceiver.this.lastState = currentState;
            }
        }, filter, null, handler);
    }

    public void addListener(SDKEventListener listener) {
        this.listeners.add(listener);
    }

    private static enum State {
        STARTED,
        STOPPED,
        RESET;

    }
}

